package com.mulesoft.connectors.commons.template.connection.provider;

import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;

import static org.mule.runtime.api.connection.ConnectionValidationResult.failure;
import static org.mule.runtime.api.connection.ConnectionValidationResult.success;

/**
 * Interface that provides basic functionality for connection providers.
 * This interface delegates the validation of the connection and it's disconnection to the connection object itself.
 *
 * @param <C> The type of connection generated.
 */
public interface ConnectorConnectionProvider<C extends ConnectorConnection> extends ConnectionProvider<C> {

    /**
     * Delegates to the connection it's own disposal, freeing all its allocated resources
     *
     * @param connection a non {@code null} {@code Connection}.
     */
    default void disconnect(C connection) {
        connection.disconnect();
    }

    /**
     * Validates the given {@link C}.
     * Delegates the validation to the connection itself. If the connection fails, it should throw an exception.
     *
     * @param connection a non {@code null} {@link C}.
     * @return a {@link ConnectionValidationResult} indicating if the connection is valid or not.
     */
    default ConnectionValidationResult validate(C connection) {
        try {
            connection.validate();
            return success();
        } catch (Exception e) {
            return failure(e.getMessage(), e);
        }
    }
}
