package com.mulesoft.connectors.commons.template.service;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;

/**
 * Parent class for all Connector Services.
 *
 * @param <CONFIG>     The {@link ConnectorConfig} handled by the connector.
 * @param <CONNECTION> The {@link ConnectorConnection} handled by the connector.
 */
public class BlockingConnectorService<CONFIG extends ConnectorConfig, CONNECTION extends ConnectorConnection> implements ConnectorService{
    private final CONFIG config;
    private final CONNECTION connection;

    /**
     * Default constructor. Sets both config and connection on the class.
     *
     * @param config     The {@link ConnectorConfig} handled by the connector.
     * @param connection The {@link ConnectorConnection} handled by the connector.
     */
    public BlockingConnectorService(CONFIG config, CONNECTION connection) {
        this.config = config;
        this.connection = connection;
    }

    /**
     * Gets the config.
     *
     * @return CONFIG The config.
     */
    protected CONFIG getConfig() {
        return this.config;
    }

    /**
     * Gets the connection.
     *
     * @return CONNECTION The connection.
     */
    protected CONNECTION getConnection() {
        return this.connection;
    }
}
