package com.mulesoft.connectors.commons.template.service;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

/**
 * Implementation of {@link BlockingConnectorService} that adds the {@link CompletionCallback} to itself, allowing only methods
 * in this class that return the same payload type and attributes type.
 *
 * @param <CONFIG>     The {@link ConnectorConfig} handled by the connector.
 * @param <CONNECTION> The {@link ConnectorConnection} handled by the connector.
 * @param <PAYLOAD>    The type of the payload to be handled.
 * @param <ATTRIBUTES> The type of the attributes to be handled.
 */
public class NonBlockingConnectorService<CONFIG extends ConnectorConfig, CONNECTION extends ConnectorConnection, PAYLOAD, ATTRIBUTES> extends BlockingConnectorService<CONFIG, CONNECTION> {
    private final CompletionCallback<PAYLOAD, ATTRIBUTES> completionCallback;

    /**
     * Default constructor. Sets config, connection and completion callback on the class.
     *
     * @param config             The {@link ConnectorConfig} handled by the connector.
     * @param connection         The {@link ConnectorConnection} handled by the connector.
     * @param completionCallback The {@link CompletionCallback} to make effective the return value.
     */
    public NonBlockingConnectorService(CONFIG config, CONNECTION connection, CompletionCallback<PAYLOAD, ATTRIBUTES> completionCallback) {
        super(config, connection);
        this.completionCallback = completionCallback;
    }

    /**
     * Gets the completion callback.
     *
     * @return CompletionCallback The completion callback.
     */
    public CompletionCallback<PAYLOAD, ATTRIBUTES> getCompletionCallback() {
        return completionCallback;
    }
}
