/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.commons.template.operation;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.mulesoft.connectors.commons.template.service.ConnectorService;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mule.commons.atlantic.Atlantic;
import org.mule.commons.atlantic.execution.builder.BiFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.FunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.factory.InstanceExecutionBuilderFactory;
import org.mule.commons.atlantic.lambda.function.TriFunction;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

public class NonBlockingConnectorOperation<CONFIG extends ConnectorConfig, CONNECTION extends ConnectorConnection, SERVICE extends ConnectorService, PAYLOAD, ATTRIBUTES, ERROR extends Enum> {
    private final TriFunction<CONFIG, CONNECTION, CompletionCallback<PAYLOAD, ATTRIBUTES>, SERVICE> serviceConstructorCall;
    private final ERROR unexpectedErrorValue;

    public NonBlockingConnectorOperation(TriFunction<CONFIG, CONNECTION, CompletionCallback<PAYLOAD, ATTRIBUTES>, SERVICE> serviceConstructorCall, ERROR unexpectedErrorValue) {
        this.serviceConstructorCall = serviceConstructorCall;
        this.unexpectedErrorValue = unexpectedErrorValue;
    }

    protected NonBlockingConnectorOperation(Class<SERVICE> serviceClass, Function<Class<SERVICE>, Class<? extends SERVICE>> transformer, ERROR unexpectedErrorValue) {
        this((config, connection, completionCallback) -> (ConnectorService)Stream.of(Optional.of(serviceClass).filter(Class::isInterface).map(transformer).orElse(serviceClass).getDeclaredConstructors()).filter(constructor -> ConnectorConfig.class.isAssignableFrom(constructor.getParameterTypes()[0]) && ConnectorConnection.class.isAssignableFrom(constructor.getParameterTypes()[1]) && CompletionCallback.class.isAssignableFrom(constructor.getParameterTypes()[2])).findFirst().orElseThrow(NoSuchMethodException::new).newInstance(config, connection, completionCallback), unexpectedErrorValue);
    }

    protected NonBlockingConnectorOperation(Class<SERVICE> serviceClass, ERROR unexpectedErrorValue) {
        this(serviceClass, clazz -> {
            try {
                return Class.forName(String.format("%sImpl", serviceClass.getName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }, unexpectedErrorValue);
    }

    protected <RESULT> InstanceExecutionBuilderFactory<SERVICE, RESULT> newExecutionBuilderFactory(CONFIG config, CONNECTION connection, CompletionCallback<PAYLOAD, ATTRIBUTES> completionCallback) {
        return (InstanceExecutionBuilderFactory)((InstanceExecutionBuilderFactory)Atlantic.newInstanceExecutionBuilder((Object)((FunctionExecutionBuilder)((BiFunctionExecutionBuilder)Atlantic.newStaticExecutionBuilder().execute(this.serviceConstructorCall).withParam(config)).withParam(connection)).withParam(completionCallback)).withIgnoredExceptionType(ModuleException.class)).withExceptionHandler(Throwable.class, t -> {
            throw new ModuleException((ErrorTypeDefinition)this.unexpectedErrorValue, t);
        });
    }
}

