/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.commons.template.operation.pagination;

import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.runtime.api.util.MultiMap;

public class OffsetPaginationContext {
    private final String relativePath;
    private final Map<String, String> pathParams;
    private final MultiMap<String, String> queryParams;
    private final MultiMap<String, String> headers;
    private final InputStream requestBody;
    private final Consumer<OffsetPaginationContext> advancePage;
    private final int pageSize;
    private int offset;
    private int totalResults;

    public OffsetPaginationContext(String relativePath, Map<String, String> pathParams, MultiMap<String, String> queryParams, MultiMap<String, String> headers, InputStream requestBody, Consumer<OffsetPaginationContext> advancePage, int pageSize) {
        this(relativePath, pathParams, queryParams, headers, requestBody, advancePage, pageSize, 0);
    }

    public OffsetPaginationContext(String relativePath, Map<String, String> pathParams, MultiMap<String, String> queryParams, MultiMap<String, String> headers, InputStream requestBody, Consumer<OffsetPaginationContext> advancePage, int pageSize, int initialOffset) {
        this.relativePath = relativePath;
        this.pathParams = pathParams;
        this.queryParams = queryParams;
        this.headers = headers;
        this.requestBody = requestBody;
        this.advancePage = advancePage;
        this.pageSize = pageSize;
        this.offset = initialOffset;
    }

    public Integer nextPage() {
        this.offset += this.pageSize;
        this.advancePage.accept(this);
        return this.offset;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public InputStream getRequestBody() {
        return this.requestBody;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public void setTotalResults(int value) {
        this.totalResults = value;
    }
}

