package com.mulesoft.connectors.http.commons.connection.provider;

import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.connection.provider.param.basic.BasicAuthParameterGroup;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

import static org.mule.runtime.extension.api.annotation.param.ParameterGroup.CONNECTION;
import static org.mule.runtime.http.api.client.auth.HttpAuthentication.basic;

public abstract class AbstractBasicHttpConnectionProvider<C extends ConnectorHttpConnection> extends AbstractHttpConnectionProvider<C, BasicAuthParameterGroup> implements CachedConnectionProvider<C> {

    @ParameterGroup(name = CONNECTION)
    @Placement(order = 1)
    private BasicAuthParameterGroup connectionParams;

    @Override
    public BasicAuthParameterGroup getConnectionParams() {
        return connectionParams;
    }

    @Override
    protected MultiMap<String, String> getAuthorizationHeaders(HttpClient httpClient) {
        return new MultiMap<>();
    }

    @Override
    protected HttpAuthentication getAuthentication(HttpClient httpClient) {
        return basic(connectionParams.getUserName(), connectionParams.getPassword()).build();
    }
}
