package com.mulesoft.connectors.http.commons.connection.provider;

import com.mulesoft.connectors.commons.template.connection.provider.ConnectorConnectionProvider;
import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.connection.provider.param.ConnectionParameterGroup;
import com.mulesoft.connectors.http.commons.connection.provider.param.proxy.HttpProxyConfig;
import org.mule.commons.atlantic.Atlantic;
import org.mule.commons.atlantic.lambda.function.TriFunction;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;

import javax.inject.Inject;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;
import static org.mule.runtime.core.api.lifecycle.LifecycleUtils.initialiseIfNeeded;

public abstract class AbstractHttpConnectionProvider<C extends ConnectorHttpConnection, P extends ConnectionParameterGroup> implements ConnectorConnectionProvider<C>, Initialisable {

    @RefName
    private String configName;

    @Parameter
    @Optional
    @Placement(tab = "Proxy", order = 3)
    @Expression(NOT_SUPPORTED)
    @DisplayName("Proxy Configuration")
    private HttpProxyConfig proxyConfig;

    @Inject
    private HttpService httpService;

    @Override
    public void initialise() throws InitialisationException {
        initialiseIfNeeded(getConnectionParams().getTlsContext());
    }

    protected abstract TriFunction<HttpClient, HttpAuthentication, MultiMap<String, String>, C> getConnectionConstructor();

    protected abstract MultiMap<String, String> getAuthorizationHeaders(HttpClient httpClient) throws ConnectionException;

    protected abstract HttpAuthentication getAuthentication(HttpClient httpClient) throws ConnectionException;

    protected abstract P getConnectionParams();

    public C connect() throws ConnectionException {
        HttpClient httpClient = httpService.getClientFactory().create(new HttpClientConfiguration.Builder()
                .setTlsContextFactory(getConnectionParams().getTlsContext())
                .setProxyConfig(proxyConfig)
                .setClientSocketProperties(TcpClientSocketProperties.builder()
                        .connectionTimeout(getConnectionParams().getConnectionTimeout())
                        .build())
                .setMaxConnections(getConnectionParams().getMaxConnections())
                .setUsePersistentConnections(getConnectionParams().getUsePersistentConnections())
                .setConnectionIdleTimeout(getConnectionParams().getConnectionIdleTimeout())
                .setStreaming(getConnectionParams().isStreamResponse())
                .setResponseBufferSize(getConnectionParams().getResponseBufferSize())
                .setName(configName)
                .build());
        httpClient.start();
        return Atlantic.newStaticExecutionBuilder().execute(getConnectionConstructor())
                .withParam(httpClient)
                .withParam(getAuthentication(httpClient))
                .withParam(getAuthorizationHeaders(httpClient));
    }
}
