package com.mulesoft.connectors.http.commons.connection.provider;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.connection.provider.param.ConnectionParameterGroup;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

import static java.lang.String.format;
import static org.mule.runtime.extension.api.annotation.param.ParameterGroup.CONNECTION;

public abstract class AbstractOAuth20HttpConnectionProvider<CONNECTION extends ConnectorHttpConnection> extends AbstractHttpConnectionProvider<CONNECTION, ConnectionParameterGroup> implements CachedConnectionProvider<CONNECTION> {

    @ParameterGroup(name = CONNECTION)
    @Placement(order = 1)
    private ConnectionParameterGroup connectionParams;

    private AuthorizationCodeState state;

    @Override
    protected MultiMap<String, String> getAuthorizationHeaders(HttpClient httpClient) throws ConnectionException {
        return new MultiMap<>(ImmutableMap.<String, String>builder()
                .put("Authorization", format("Bearer %s", state.getAccessToken()))
                .build());
    }

    @Override
    protected HttpAuthentication getAuthentication(HttpClient httpClient) throws ConnectionException {
        return null;
    }

    @Override
    public ConnectionParameterGroup getConnectionParams() {
        return connectionParams;
    }
}
