package com.mulesoft.connectors.http.commons.connection.provider.param.basic;

import com.mulesoft.connectors.http.commons.connection.provider.param.ConnectionParameterGroup;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

import static org.mule.runtime.http.api.client.auth.HttpAuthentication.basic;

public class BasicAuthParameterGroup extends ConnectionParameterGroup {

    /**
     * The user name
     */
    @Parameter
    @Placement(order = 1)
    @DisplayName("User Name")
    private String userName;

    /**
     * The password
     */
    @Parameter
    @Placement(order = 2)
    @Password
    @DisplayName("Password")
    private String password;

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
