package com.mulesoft.connectors.http.commons.service;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.commons.template.service.DefaultConnectorService;
import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.extensions.request.builder.RequestBuilder;
import com.mulesoft.extensions.request.builder.handler.ResponseHandler;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;

import static org.mule.runtime.extension.api.error.MuleErrors.CONNECTIVITY;

public class HttpClientService<CONFIG extends ConnectorConfig, CONNECTION extends ConnectorHttpConnection> extends DefaultConnectorService<CONFIG, CONNECTION> {

    public HttpClientService(CONFIG config, CONNECTION connection) {
        super(config, connection);
    }

    public HttpResponse get(String relativePath,
                            Map<String, String> pathParams,
                            MultiMap<String, String> queryParams,
                            MultiMap<String, String> headers,
                            HttpEntity body) {
        return invoke(getConnection()::get, relativePath, pathParams, queryParams, headers, body);
    }

    public HttpResponse post(String relativePath,
                             Map<String, String> pathParams,
                             MultiMap<String, String> queryParams,
                             MultiMap<String, String> headers,
                             HttpEntity body) {
        return invoke(getConnection()::post, relativePath, pathParams, queryParams, headers, body);
    }

    public HttpResponse put(String relativePath,
                            Map<String, String> pathParams,
                            MultiMap<String, String> queryParams,
                            MultiMap<String, String> headers,
                            HttpEntity body) {
        return invoke(getConnection()::put, relativePath, pathParams, queryParams, headers, body);
    }

    public HttpResponse delete(String relativePath,
                               Map<String, String> pathParams,
                               MultiMap<String, String> queryParams,
                               MultiMap<String, String> headers,
                               HttpEntity body) {
        return invoke(getConnection()::delete, relativePath, pathParams, queryParams, headers, body);
    }

    public HttpResponse head(String relativePath,
                             Map<String, String> pathParams,
                             MultiMap<String, String> queryParams,
                             MultiMap<String, String> headers,
                             HttpEntity body) {
        return invoke(getConnection()::head, relativePath, pathParams, queryParams, headers, body);
    }

    public HttpResponse options(String relativePath,
                                Map<String, String> pathParams,
                                MultiMap<String, String> queryParams,
                                MultiMap<String, String> headers,
                                HttpEntity body) {
        return invoke(getConnection()::options, relativePath, pathParams, queryParams, headers, body);
    }

    public HttpResponse patch(String relativePath,
                              Map<String, String> pathParams,
                              MultiMap<String, String> queryParams,
                              MultiMap<String, String> headers,
                              HttpEntity body) {
        return invoke(getConnection()::patch, relativePath, pathParams, queryParams, headers, body);
    }

    private HttpResponse invoke(BiFunction<String, ResponseHandler<HttpResponse>, RequestBuilder<HttpResponse>> operation, String relativePath, Map<String, String> pathParams, MultiMap<String, String> queryParams, MultiMap<String, String> headers, HttpEntity body) {
        try {
            return operation.apply(relativePath, response -> response)
                    .pathParams(pathParams)
                    .queryParams(queryParams)
                    .headers(headers)
                    .followRedirects()
                    .entity(Optional.ofNullable(body).orElseGet(EmptyHttpEntity::new))
                    .execute();
        } catch (IOException | TimeoutException e) {
            throw new ModuleException(CONNECTIVITY, e);
        }
    }
}
