/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.http.commons.connection.provider;

import com.mulesoft.connectors.commons.template.connection.provider.ConnectorConnectionProvider;
import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.connection.provider.param.ConnectionParameterGroup;
import com.mulesoft.connectors.http.commons.connection.provider.param.proxy.HttpProxyConfig;
import javax.inject.Inject;
import org.mule.commons.atlantic.Atlantic;
import org.mule.commons.atlantic.execution.builder.BiFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.FunctionExecutionBuilder;
import org.mule.commons.atlantic.lambda.function.TriFunction;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;

public abstract class AbstractHttpConnectionProvider<C extends ConnectorHttpConnection, P extends ConnectionParameterGroup>
implements ConnectorConnectionProvider<C>,
Initialisable {
    @RefName
    private String configName;
    @Parameter
    @Optional
    @Placement(tab="Proxy", order=3)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Proxy Configuration")
    private HttpProxyConfig proxyConfig;
    @Inject
    private HttpService httpService;

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)((ConnectionParameterGroup)this.getConnectionParams()).getTlsContext());
    }

    protected abstract TriFunction<HttpClient, HttpAuthentication, MultiMap<String, String>, C> getConnectionConstructor();

    protected abstract MultiMap<String, String> getAuthorizationHeaders(HttpClient var1) throws ConnectionException;

    protected abstract HttpAuthentication getAuthentication(HttpClient var1) throws ConnectionException;

    protected abstract P getConnectionParams();

    public C connect() throws ConnectionException {
        HttpClient httpClient = this.httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setTlsContextFactory(((ConnectionParameterGroup)this.getConnectionParams()).getTlsContext()).setProxyConfig((ProxyConfig)this.proxyConfig).setClientSocketProperties(TcpClientSocketProperties.builder().connectionTimeout(((ConnectionParameterGroup)this.getConnectionParams()).getConnectionTimeout()).build()).setMaxConnections(((ConnectionParameterGroup)this.getConnectionParams()).getMaxConnections().intValue()).setUsePersistentConnections(((ConnectionParameterGroup)this.getConnectionParams()).getUsePersistentConnections()).setConnectionIdleTimeout(((ConnectionParameterGroup)this.getConnectionParams()).getConnectionIdleTimeout().intValue()).setStreaming(((ConnectionParameterGroup)this.getConnectionParams()).isStreamResponse()).setResponseBufferSize(((ConnectionParameterGroup)this.getConnectionParams()).getResponseBufferSize()).setName(this.configName).build());
        httpClient.start();
        return (C)((ConnectorHttpConnection)((FunctionExecutionBuilder)((BiFunctionExecutionBuilder)Atlantic.newStaticExecutionBuilder().execute(this.getConnectionConstructor()).withParam((Object)httpClient)).withParam((Object)this.getAuthentication(httpClient))).withParam(this.getAuthorizationHeaders(httpClient)));
    }
}

