/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.http.commons.connection.provider;

import com.mulesoft.connectors.commons.template.connection.provider.ConnectorConnectionProvider;
import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.connection.provider.ProxyConfiguration;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.NtlmProxyConfigBuilder;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;

public abstract class AbstractHttpConnectionProvider<C extends ConnectorHttpConnection>
implements ConnectorConnectionProvider<C> {
    @RefName
    private String configName;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=3)
    @DisplayName(value="Maximum outbound connections")
    @Summary(value="The maximum number of outbound connections that will be kept open at the same time.")
    private Integer maxConnections;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="30000")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=4)
    @DisplayName(value="Connection idle timeout")
    @Summary(value="The number of milliseconds that a connection can remain idle before it is closed.")
    private Integer connectionIdleTimeout;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="30000")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=6)
    @DisplayName(value="Connection timeout (ms)")
    @Summary(value="Defines how long to wait for the outbound connection to be created.")
    private Integer connectionTimeout;
    @Parameter
    @DisplayName(value="Proxy")
    @Summary(value="Proxy Configuration")
    @Placement(tab="Advanced", order=3)
    private ProxyConfiguration proxyConfig;
    @Inject
    private HttpService httpService;

    public C connect() throws ConnectionException {
        HttpClient httpClient = this.httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setProxyConfig(Optional.ofNullable(this.proxyConfig.getNtlmDomain()).map(arg_0 -> ((NtlmProxyConfigBuilder)ProxyConfig.NtlmProxyConfig.builder()).ntlmDomain(arg_0)).orElseGet(ProxyConfig::builder).host(this.proxyConfig.getHost()).port(this.proxyConfig.getPort()).nonProxyHosts(this.proxyConfig.getNonProxyHosts().stream().collect(Collectors.joining(","))).username(this.proxyConfig.getUsername()).password(this.proxyConfig.getPassword()).build()).setClientSocketProperties(TcpClientSocketProperties.builder().connectionTimeout(this.connectionTimeout).build()).setMaxConnections(this.maxConnections.intValue()).setConnectionIdleTimeout(this.connectionIdleTimeout.intValue()).setName(this.configName).build());
        httpClient.start();
        return this.connect(httpClient);
    }

    public HttpClientConfiguration.Builder customizeHttpClient(HttpClientConfiguration.Builder builder) {
        return builder;
    }

    public abstract C connect(HttpClient var1) throws ConnectionException;
}

