/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.http.commons.connection.provider.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.connection.provider.AbstractHttpConnectionProvider;
import com.mulesoft.connectors.http.commons.connection.provider.jwt.JwtTemplate;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public abstract class JwtConnectionProvider<CONNECTION extends ConnectorHttpConnection>
extends AbstractHttpConnectionProvider<CONNECTION>
implements JwtTemplate<CONNECTION> {
    private final ObjectMapper mapper = new ObjectMapper();
    @Parameter
    @Placement(order=1)
    @Summary(value="The path to the keystore used to sign the JWT claims.")
    @Path(type=PathModel.Type.FILE)
    private String keystorePath;

    @Override
    public String getKeystorePath() {
        return this.keystorePath;
    }

    @Override
    public Map<Object, Object> parseTokenResponse(String response) throws ConnectionException {
        try {
            return (Map)this.mapper.readValue(response, HashMap.class);
        }
        catch (IOException e) {
            throw new ConnectionException((Throwable)e);
        }
    }
}

