/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.http.commons.connection.provider.jwt;

import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.connection.provider.jwt.AccessTokenRequestParameterGroup;
import com.mulesoft.connectors.http.commons.connection.provider.jwt.JwtClaimsParameterGroup;
import com.mulesoft.connectors.http.commons.connection.provider.jwt.JwtHeadersParameterGroup;
import com.mulesoft.extensions.request.builder.RequestBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.JacksonSerializer;
import io.jsonwebtoken.io.Serializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.Key;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClient;

public interface JwtTemplate<CONNECTION extends ConnectorHttpConnection> {
    default public CONNECTION connect(HttpClient httpClient) throws ConnectionException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            MultiMap result = new MultiMap();
            HashMap<String, String> headers = new HashMap<String, String>();
            JwtHeadersParameterGroup headersGroup = this.getHeadersGroup();
            Optional.ofNullable(headersGroup.getAlg()).ifPresent(alg -> headers.put("alg", (String)alg));
            Optional.ofNullable(headersGroup.getTyp()).ifPresent(typ -> headers.put("typ", (String)typ));
            Optional.ofNullable(headersGroup.getCty()).ifPresent(cty -> headers.put("cty", (String)cty));
            headers.putAll(headersGroup.getCustomHeaders());
            HashMap<String, Object> claims = new HashMap<String, Object>();
            JwtClaimsParameterGroup claimsGroup = this.getClaimsGroup();
            Optional.ofNullable(claimsGroup.getIss()).ifPresent(iss -> claims.put("iss", iss));
            Optional.ofNullable(claimsGroup.getAud()).ifPresent(aud -> claims.put("aud", aud));
            claims.put("exp", Optional.ofNullable(claimsGroup.getExp()).map(Long::valueOf).orElse(Instant.now().getEpochSecond() + 60L));
            Optional.ofNullable(claimsGroup.getIat()).map(Integer::valueOf).ifPresent(iat -> claims.put("iat", iat));
            claims.put("jti", Optional.ofNullable(claimsGroup.getJti()).orElse(new String(RandomUtils.nextBytes((int)128))));
            Optional.ofNullable(claimsGroup.getNbf()).map(Integer::valueOf).ifPresent(nbf -> claims.put("nbf", nbf));
            Optional.ofNullable(claimsGroup.getSub()).ifPresent(sub -> claims.put("sub", sub));
            claims.putAll(claimsGroup.getCustomClaims());
            HashMap<String, String> accessTokenRequestBodyParameters = new HashMap<String, String>();
            accessTokenRequestBodyParameters.putAll(this.getAccessTokenRequestParameters().getParameters());
            accessTokenRequestBodyParameters.put("assertion", Jwts.builder().signWith((Key)((KeyPair)KeyPair.class.cast(new PEMReader((Reader)new FileReader(new File(this.getKeystorePath()))).readObject())).getPrivate(), SignatureAlgorithm.valueOf((String)headersGroup.getAlg())).setHeaderParams(headers).addClaims(claims).serializeToJsonWith((Serializer)new JacksonSerializer()).compact());
            result.put((Object)"Authorization", (Object)String.format("Bearer %s", this.parseTokenResponse((String)RequestBuilder.post((HttpClient)httpClient, (String)this.getAccessTokenRequestParameters().getUrl()).entity(accessTokenRequestBodyParameters.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"))).execute()).get("access_token").toString()));
            return this.connect(httpClient, (MultiMap<String, String>)result);
        }
        catch (FileNotFoundException e) {
            throw new ConnectionException("Unable to find keystore file.", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new ConnectionException("Timeout.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ConnectionException("An error occurred while retrieving the access token.", (Throwable)e);
        }
    }

    public Map<Object, Object> parseTokenResponse(String var1) throws ConnectionException;

    public String getKeystorePath();

    public CONNECTION connect(HttpClient var1, MultiMap<String, String> var2);

    public JwtHeadersParameterGroup getHeadersGroup();

    public JwtClaimsParameterGroup getClaimsGroup();

    public AccessTokenRequestParameterGroup getAccessTokenRequestParameters();
}

