package com.mulesoft.connectors.http.commons.connection;

import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.mulesoft.extensions.request.builder.RequestBuilder;
import com.mulesoft.extensions.request.builder.handler.DefaultResponseHandler;
import com.mulesoft.extensions.request.builder.handler.ResponseHandler;
import org.mule.commons.atlantic.lambda.function.TriFunction;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

public class ConnectorHttpConnection implements ConnectorConnection {
    private final HttpClient httpClient;
    private final HttpAuthentication authentication;
    private final MultiMap<String, String> authenticationHeaders;

    public ConnectorHttpConnection(HttpClient httpClient, HttpAuthentication authentication) {
        this(httpClient, authentication, new MultiMap<>());
    }

    public ConnectorHttpConnection(HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> authenticationHeaders) {
        this.httpClient = httpClient;
        this.authentication = authentication;
        this.authenticationHeaders = authenticationHeaders;
    }

    public RequestBuilder<String> get(String relativePath) {
        return create(RequestBuilder::get, relativePath);
    }

    public <T> RequestBuilder<T> get(String relativePath, ResponseHandler<T> responseHandler) {
        return create(RequestBuilder::get, relativePath, responseHandler);
    }

    public RequestBuilder<String> post(String relativePath) {
        return create(RequestBuilder::post, relativePath);
    }

    public <T> RequestBuilder<T> post(String relativePath, ResponseHandler<T> responseHandler) {
        return create(RequestBuilder::post, relativePath, responseHandler);
    }

    public RequestBuilder<String> put(String relativePath) {
        return create(RequestBuilder::put, relativePath);
    }

    public <T> RequestBuilder<T> put(String relativePath, ResponseHandler<T> responseHandler) {
        return create(RequestBuilder::put, relativePath, responseHandler);
    }

    public RequestBuilder<String> delete(String relativePath) {
        return create(RequestBuilder::delete, relativePath);
    }

    public <T> RequestBuilder<T> delete(String relativePath, ResponseHandler<T> responseHandler) {
        return create(RequestBuilder::delete, relativePath, responseHandler);
    }

    public RequestBuilder<String> head(String relativePath) {
        return create(RequestBuilder::head, relativePath);
    }

    public <T> RequestBuilder<T> head(String relativePath, ResponseHandler<T> responseHandler) {
        return create(RequestBuilder::head, relativePath, responseHandler);
    }

    public RequestBuilder<String> options(String relativePath) {
        return create(RequestBuilder::options, relativePath);
    }

    public <T> RequestBuilder<T> options(String relativePath, ResponseHandler<T> responseHandler) {
        return create(RequestBuilder::options, relativePath, responseHandler);
    }

    public RequestBuilder<String> patch(String relativePath) {
        return create(RequestBuilder::patch, relativePath);
    }

    public <T> RequestBuilder<T> patch(String relativePath, ResponseHandler<T> responseHandler) {
        return create(RequestBuilder::patch, relativePath, responseHandler);
    }

    private <T> RequestBuilder<T> create(TriFunction<HttpClient, String, ResponseHandler<T>, RequestBuilder<T>> factoryMethod, String relativePath, ResponseHandler<T> responseHandler) {
        try {
            return factoryMethod.apply(httpClient, relativePath, responseHandler)
                    .headers(authenticationHeaders)
                    .authentication(authentication);
        } catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private RequestBuilder<String> create(TriFunction<HttpClient, String, ResponseHandler<String>, RequestBuilder<String>> factoryMethod, String relativePath) {
        return create(factoryMethod, relativePath, new DefaultResponseHandler());
    }

    protected HttpClient getHttpClient() {
        return httpClient;
    }

    @Override
    public void disconnect() {
        httpClient.stop();
    }

    @Override
    public void validate() {
        // Do nothing. Child classes can implement this methods and newExecutionBuilder a validation.
    }
}
