package com.mulesoft.connectors.http.commons.connection.provider;

import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.client.HttpClientConfiguration;

import static org.mule.runtime.core.api.lifecycle.LifecycleUtils.initialiseIfNeeded;

public interface TlsAwareTemplate extends Initialisable {

    default void initialise() throws InitialisationException {
        initialiseIfNeeded(getTlsContext());
    }

    default HttpClientConfiguration.Builder customizeHttpClient(HttpClientConfiguration.Builder builder) {
        return builder.setTlsContextFactory(getTlsContext());
    }

    TlsContextFactory getTlsContext();
}
