package com.mulesoft.connectors.http.commons.connection.provider.credentials.ntlm;

import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.connection.provider.credentials.LoginCredentialsConnectionProvider;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

import static org.mule.runtime.extension.api.annotation.param.ParameterGroup.ADVANCED;

public abstract class NtlmLoginCredentialsConnectionProvider<C extends ConnectorHttpConnection> extends LoginCredentialsConnectionProvider<C> {

    /**
     * The name of the domain used to connect.
     */
    @Parameter
    @Placement(order = 3)
    @DisplayName("Domain name")
    @Summary("The name of the domain used to connect.")
    private String domain;

    /**
     * The ID of the connecting workstation.
     */
    @Parameter
    @Optional
    @Placement(tab = ADVANCED, order = 3)
    @DisplayName("Workstation ID")
    @Summary("The ID of the connecting workstation.")
    private String workstation;

    @Override
    public C connect(HttpClient httpClient, HttpAuthentication authentication) {
        return connect(httpClient, HttpAuthentication.ntlm(authentication.getUsername(), authentication.getPassword())
                .domain(domain)
                .workstation(workstation)
        .build());
    }

    public abstract C connect(HttpClient httpClient, HttpAuthentication.HttpNtlmAuthentication authentication);
}
