package com.mulesoft.connectors.http.commons.connection.provider.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.connection.provider.AbstractHttpConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import static org.mule.runtime.api.meta.model.display.PathModel.Type.FILE;

public abstract class JwtConnectionProvider<CONNECTION extends ConnectorHttpConnection> extends AbstractHttpConnectionProvider<CONNECTION> implements JwtTemplate<CONNECTION> {
    // FIXME: Replace with Mulesoft parser.
    private final ObjectMapper mapper = new ObjectMapper();

    /**
     * The path to the keystore used to sign the JWT claims.
     */
    @Parameter
    @Placement(order = 1)
    @Summary("The path to the keystore used to sign the JWT claims.")
    @Path(type = FILE)
    private String keystorePath;

    @Override
    public String getKeystorePath() {
        return keystorePath;
    }

    @Override
    public Map<Object, Object> parseTokenResponse(String response) throws ConnectionException {
        try {
            return mapper.readValue(response, HashMap.class);
        } catch (IOException e) {
            throw new ConnectionException(e);
        }
    }
}