package com.mulesoft.connectors.http.commons.operation;

import com.mulesoft.connectors.commons.template.operation.BlockingConnectorOperation;
import com.mulesoft.connectors.http.commons.config.HttpConnectorConfig;
import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.service.HttpClientService;
import org.mule.commons.atlantic.execution.builder.PentaFunctionExecutionBuilder;
import org.mule.commons.atlantic.lambda.function.HexaFunction;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import java.io.InputStream;
import java.util.Map;
import java.util.Optional;

public class HttpOperation<CONFIG extends HttpConnectorConfig, CONNECTION extends ConnectorHttpConnection> extends BlockingConnectorOperation<CONFIG, CONNECTION, HttpClientService<CONFIG, CONNECTION>> {

    private final HexaFunction<HttpClientService<CONFIG, CONNECTION>, String, Map<String, String>, MultiMap<String, String>, MultiMap<String, String>, HttpEntity, HttpResponse> serviceCall;

    protected HttpOperation(HexaFunction<HttpClientService<CONFIG, CONNECTION>, String, Map<String, String>, MultiMap<String, String>, MultiMap<String, String>, HttpEntity, HttpResponse> serviceCall, ErrorTypeDefinition<?> unexpectedErrorValue) {
        super(HttpClientService::new, unexpectedErrorValue);
        this.serviceCall = serviceCall;
    }

    protected PentaFunctionExecutionBuilder<String, Map<String, String>, MultiMap<String, String>, MultiMap<String, String>, HttpEntity, Result<InputStream, MultiMap<String, String>>> newHttpExecutionBuilder(CONFIG config, CONNECTION connection) {
        return newExecutionBuilder(config, connection).execute(serviceCall, response -> Optional.ofNullable(response)
                .map(HttpResponse::getEntity)
                .map(HttpEntity::getContent)
                .map(Result.<InputStream, MultiMap<String, String>>builder()
                        .attributes(new MultiMap<>())::output)
                .orElse(Result.builder())
                .build());
    }
}
