package com.mulesoft.connectors.http.commons.util;

import com.mulesoft.connectors.http.commons.operation.HttpOperation;
import org.mule.commons.atlantic.execution.context.listener.PostExecutionListener;
import org.mule.commons.atlantic.execution.context.listener.PreExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Optional;

public class OperationLogListener<RESULT> implements PreExecutionListener, PostExecutionListener<RESULT> {
    private final static Logger logger = LoggerFactory.getLogger(OperationLogListener.class);
    private final String executionName;

    public OperationLogListener(String executionName) {
        this.executionName = executionName;
    }

    public OperationLogListener(Class<? extends HttpOperation> singleOperationClass) {
        this(singleOperationClass.getSimpleName());
    }

    @Override
    public void onPreExecute(List<Object> params) {
        logger.info("Executing operation '{}'.", executionName);
    }

    @Override
    public void onPostExecute(List<Object> params, RESULT returnedObject) {
        logger.info("Operation '{}' successfully executed.", executionName);
        Optional.ofNullable(returnedObject).map(Object::toString).ifPresent(logger::info);
    }
}
