package com.mulesoft.connectors.http.commons.connection.provider;

import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import java.util.List;

@DisplayName("Proxy")
@Xml(prefix = "proxy")
public class ProxyConfiguration {

    /**
     * Host where the proxy requests will be sent.
     */
    @Parameter
    @DisplayName("Proxy host")
    @Summary("Host where the proxy requests will be sent.")
    private String host;

    /**
     * Port where the proxy requests will be sent.
     */
    @Parameter
    @DisplayName("Proxy port")
    @Summary("Port where the proxy requests will be sent.")
    private int port = Integer.MAX_VALUE;

    /**
     * The username to authenticate against the proxy.
     */
    @Parameter
    @Optional
    @DisplayName("Proxy username")
    @Summary("The username to authenticate against the proxy.")
    private String username;

    /**
     * The password to authenticate against the proxy.
     */
    @Parameter
    @Optional
    @Password
    @DisplayName("Proxy password")
    @Summary("The password to authenticate against the proxy.")
    private String password;

    /**
     * A list of hosts against which the proxy should not be used.
     */
    @Parameter
    @Optional
    @DisplayName("Non proxied hosts")
    @Summary("A list of hosts against which the proxy should not be used.")
    private List<String> nonProxyHosts;

    /**
     * The domain to authenticate against the proxy.
     */
    @Parameter
    @Optional
    @DisplayName("NTLM Domain")
    @Summary("The domain to authenticate against the proxy.")
    private String ntlmDomain;

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<String> getNonProxyHosts() {
        return nonProxyHosts;
    }

    public void setNonProxyHosts(List<String> nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public String getNtlmDomain() {
        return ntlmDomain;
    }

    public void setNtlmDomain(String ntlmDomain) {
        this.ntlmDomain = ntlmDomain;
    }
}
