package com.mulesoft.connectors.http.commons.connection.provider.credentials;

import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.connection.provider.AbstractHttpConnectionProvider;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

import static org.mule.runtime.http.api.client.auth.HttpAuthentication.basic;

public abstract class LoginCredentialsConnectionProvider<C extends ConnectorHttpConnection> extends AbstractHttpConnectionProvider<C> {

    /**
     * The user name
     */
    @Parameter
    @Placement(order = 1)
    @DisplayName("Username")
    private String username;

    /**
     * The password
     */
    @Parameter
    @Password
    @Placement(order = 2)
    @DisplayName("Password")
    private String password;

    @Override
    public final C connect(HttpClient httpClient) {
        return connect(httpClient, basic(username, password).build());
    }

    public abstract C connect(HttpClient httpClient, HttpAuthentication authentication);
}
