package com.mulesoft.connectors.http.commons.connection.provider.credentials;

import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.connection.provider.AbstractHttpConnectionProvider;
import com.mulesoft.connectors.http.commons.connection.provider.TlsAwareTemplate;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;
import static org.mule.runtime.core.api.lifecycle.LifecycleUtils.initialiseIfNeeded;
import static org.mule.runtime.extension.api.annotation.param.display.Placement.ADVANCED_TAB;
import static org.mule.runtime.http.api.client.auth.HttpAuthentication.basic;

public abstract class TlsAwareLoginCredentialsConnectionProvider<C extends ConnectorHttpConnection> extends LoginCredentialsConnectionProvider<C> implements TlsAwareTemplate {

    /**
     * Protocol to use for communication. Valid values are HTTP and HTTPS. Default value is HTTP. When using HTTPS the HTTP
     * communication is going to be secured using TLS / SSL. If HTTPS was configured as protocol then the user needs to configure
     * at least the keystore in the tls:context child element of this listener-config.
     */
    @Expression(NOT_SUPPORTED)
    @Placement(tab = ADVANCED_TAB, order = 1)
    @Parameter
    @Optional
    @DisplayName("TLS Configuration")
    @Summary("Protocol to use for communication. Valid values are HTTP and HTTPS.")
    private TlsContextFactory tlsContext;

    @Override
    public TlsContextFactory getTlsContext() {
        return tlsContext;
    }
}
