package com.mulesoft.connectors.http.commons.metadata;

import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import static org.mule.runtime.extension.api.values.ValueResolvingException.INVALID_VALUE_RESOLVER_NAME;

public class EndpointUrlValueProvider implements ValueProvider {
    private static final Logger logger = LoggerFactory.getLogger(EndpointUrlValueProvider.class);

    private Properties valueProperties;

    public EndpointUrlValueProvider() {
        try {
            valueProperties = new Properties();
            valueProperties.load(ClassLoader.getSystemResourceAsStream("endpointUrlValues.properties"));
        } catch (IOException e) {
            logger.warn("An error occurred while loading the properties file. Providing no values.", e);
        }
    }

    @Override
    public Set<Value> resolve() throws ValueResolvingException {
        Set<Value> result = new HashSet<>();
        for (Map.Entry<Object, Object> entry : valueProperties.entrySet()) {
            try {
                result.add(ValueBuilder.newValue(URLDecoder.decode(entry.getKey().toString(), "UTF-8"))
                        .withDisplayName(entry.getValue().toString()).build());
            } catch (UnsupportedEncodingException e) {
                throw new ValueResolvingException(e.getMessage(), INVALID_VALUE_RESOLVER_NAME, e);
            }
        }
        return result;
    }
}
