/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.http.commons.operation;

import com.mulesoft.connectors.commons.template.operation.BlockingConnectorPagedOperation;
import com.mulesoft.connectors.commons.template.operation.pagination.OffsetPaginationContext;
import com.mulesoft.connectors.http.commons.config.HttpConnectorConfig;
import com.mulesoft.connectors.http.commons.connection.ConnectorHttpConnection;
import com.mulesoft.connectors.http.commons.service.HttpClientService;
import com.mulesoft.connectors.http.commons.transform.Transformer;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.commons.atlantic.execution.builder.BiFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.FunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.TetraFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.TriFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.factory.InstanceExecutionBuilderFactory;
import org.mule.commons.atlantic.lambda.function.BiFunction;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class GetPaginatedOperation<CONFIG extends HttpConnectorConfig, CONNECTION extends ConnectorHttpConnection, SERVICE extends HttpClientService<CONFIG, CONNECTION>>
extends BlockingConnectorPagedOperation<CONFIG, CONNECTION, SERVICE, OffsetPaginationContext> {
    private final ErrorTypeDefinition<?> transformationErrorValue;
    private final Transformer<InputStream, Map<String, Object>> inputStreamToMapTransformer;
    private Integer totalCount = 0;
    private static final String RESPONSE_FIELD_TOTAL_COUNT = "total_count";
    private static final String RESPONSE_FIELD_ENTRIES_LIST = "entries";

    protected GetPaginatedOperation(BiFunction<CONFIG, CONNECTION, SERVICE> serviceConstructorCall, ErrorTypeDefinition<?> unexpectedErrorValue, ErrorTypeDefinition<?> transformationErrorValue, Transformer<InputStream, Map<String, Object>> inputStreamToMapTransformer) {
        super(serviceConstructorCall, unexpectedErrorValue);
        this.transformationErrorValue = transformationErrorValue;
        this.inputStreamToMapTransformer = inputStreamToMapTransformer;
    }

    protected <RESULT> List<RESULT> getPage(InstanceExecutionBuilderFactory<SERVICE, RESULT> executionBuilder, OffsetPaginationContext pagingContext) {
        HttpResponse httpResponse = (HttpResponse)((FunctionExecutionBuilder)((BiFunctionExecutionBuilder)((TriFunctionExecutionBuilder)((TetraFunctionExecutionBuilder)executionBuilder.execute(HttpClientService::get).withParam((Object)pagingContext.getRelativePath())).withParam((Object)pagingContext.getPathParams())).withParam((Object)pagingContext.getQueryParams())).withParam((Object)pagingContext.getHeaders())).withParam((Object)new InputStreamHttpEntity(pagingContext.getRequestBody()));
        pagingContext.nextPage();
        try {
            InputStream responseStream = this.getResponseStream(httpResponse);
            Map<String, Object> responseObject = this.inputStreamToMapTransformer.transform(responseStream);
            int totalResults = Integer.parseInt(responseObject.get(RESPONSE_FIELD_TOTAL_COUNT).toString());
            pagingContext.setTotalResults(totalResults);
            return (List)responseObject.get(RESPONSE_FIELD_ENTRIES_LIST);
        }
        catch (IOException e) {
            throw new ModuleException(String.format("IOException while reading response. Exception: %s.", e), this.transformationErrorValue);
        }
    }

    protected <RESULT> Optional<Integer> getTotalResults(InstanceExecutionBuilderFactory<SERVICE, RESULT> executionBuilder, OffsetPaginationContext pagingContext) {
        return Optional.of(pagingContext.getTotalResults());
    }

    private InputStream getResponseStream(HttpResponse method) throws IOException {
        InputStream result = null;
        HttpEntity responseEntity = method.getEntity();
        if (responseEntity != null) {
            result = responseEntity.getContent();
        }
        if (result == null || result.available() == 0) {
            throw new IOException("Empty stream came as response");
        }
        return result;
    }
}

