/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.ftps.api;

import com.mulesoft.extension.ftps.internal.FtpsConnectionStereotype;
import java.util.function.Consumer;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;
import org.mule.extension.ftp.internal.connection.FtpConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;

@DisplayName(value="FTPS Connection")
@Summary(value="FTP Connection with support of SSL")
@Stereotype(value=FtpsConnectionStereotype.class)
public class FtpsConnectionProvider
extends FtpConnectionProvider
implements Initialisable {
    private TlsContextFactoryBuilder tlsContextFactoryBuilder = TlsContextFactory.builder();
    @Parameter
    @Optional
    @Placement(tab="TLS", order=5)
    @DisplayName(value="TLS Configuration")
    private TlsContextFactory tlsContextFactory;

    public void initialise() throws InitialisationException {
        if (this.tlsContextFactory == null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactoryBuilder);
            this.tlsContextFactory = this.tlsContextFactoryBuilder.buildDefault();
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
    }

    protected FTPClient createClient() {
        try {
            FTPSClient client = new FTPSClient(this.tlsContextFactory.createSslContext());
            this.ifNotEmpty(this.tlsContextFactory.getEnabledProtocols(), protocols -> client.setEnabledProtocols(protocols));
            this.ifNotEmpty(this.tlsContextFactory.getEnabledCipherSuites(), ciphers -> client.setEnabledCipherSuites(ciphers));
            return client;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create FTPS client"), (Throwable)e);
        }
    }

    private void ifNotEmpty(String[] value, Consumer<String[]> consumer) {
        if (value != null && value.length != 0) {
            consumer.accept(value);
        }
    }
}

