/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.ftps.api.mode;

import com.mulesoft.extension.ftps.api.mode.FtpsMode;
import com.mulesoft.extension.ftps.api.mode.setting.ProtSetting;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPSClient;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class FtpsExplicitMode
implements FtpsMode {
    private static String PROT_SETTING_ERROR_MESSAGE = "There was an error while trying to set the PROT Setting to %s (%s)";
    @Parameter
    @Summary(value="When using explicit mode with TLS you can choose between two PROT Settings: 'CLEAR' the data will be sent plain through the data channel. 'PRIVATE' the data will be sent encrypted through the data channel. ")
    @DisplayName(value="PROT Settings")
    @Optional
    private ProtSetting protSetting;

    @Override
    public boolean usesImplicitConnection() {
        return false;
    }

    public FtpsExplicitMode() {
    }

    public FtpsExplicitMode(ProtSetting protSetting) {
        this.protSetting = protSetting;
    }

    @Override
    public void onAuthentication(FTPSClient client) throws ConnectionException {
        if (this.protSetting == null) {
            return;
        }
        try {
            client.execPBSZ(0L);
            client.execPROT(this.protSetting.getCommandValue());
        }
        catch (IOException e) {
            throw new ConnectionException(String.format(PROT_SETTING_ERROR_MESSAGE, this.protSetting.getCommandValue(), this.protSetting.name()), (Throwable)e);
        }
    }

    public ProtSetting getProtSetting() {
        return this.protSetting;
    }
}

