/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.ftps.api;

import com.mulesoft.extension.ftps.api.mode.FtpsExplicitMode;
import com.mulesoft.extension.ftps.api.mode.FtpsMode;
import com.mulesoft.extension.ftps.internal.FTPSSessionReuseClient;
import com.mulesoft.extension.ftps.internal.FtpsConnectionStereotype;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;
import org.mule.extension.file.common.api.exceptions.FileError;
import org.mule.extension.ftp.api.FTPConnectionException;
import org.mule.extension.ftp.internal.connection.FtpConnectionProvider;
import org.mule.extension.ftp.internal.connection.FtpFileSystem;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="FTPS Connection")
@Summary(value="FTP Connection with support of SSL")
@Stereotype(value=FtpsConnectionStereotype.class)
public class FtpsConnectionProvider
extends FtpConnectionProvider
implements Initialisable {
    private static final boolean USE_EXTENDED_MASTER_SECRET = "true".equals(System.getProperty("jdk.tls.useExtendedMasterSecret"));
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FtpsConnectionProvider.class.getName());
    private SSLContext context;
    private ClientSessionHostPortCache clientSessionHostPortCache;
    private TlsContextFactoryBuilder tlsContextFactoryBuilder = TlsContextFactory.builder();
    @Parameter
    @Optional
    @Placement(tab="TLS", order=5)
    @DisplayName(value="TLS Configuration")
    private TlsContextFactory tlsContextFactory;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @NullSafe(defaultImplementingType=FtpsExplicitMode.class)
    public FtpsMode ftpsMode;

    public void initialise() throws InitialisationException {
        if (this.tlsContextFactory == null) {
            this.tlsContextFactory = this.tlsContextFactoryBuilder.buildDefault();
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
        try {
            this.context = this.tlsContextFactory.createSslContext();
            if (USE_EXTENDED_MASTER_SECRET) {
                return;
            }
            SSLSessionContext clientSessionContext = this.context.getClientSessionContext();
            this.clientSessionHostPortCache = new ClientSessionHostPortCache(clientSessionContext);
        }
        catch (NoSuchFieldException e) {
            LOGGER.warn("No field 'sessionHostPortCache' in SSLSessionContext, cannot associate session to data connection for reuse. {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Could not create FTPS client"), (Throwable)e, (Initialisable)this);
        }
    }

    public FtpFileSystem connect() throws ConnectionException {
        FtpFileSystem fileSystem = super.connect();
        this.ftpsMode.onAuthentication((FTPSClient)fileSystem.getClient());
        return fileSystem;
    }

    protected FTPClient createClient() {
        try {
            FTPSSessionReuseClient client = !USE_EXTENDED_MASTER_SECRET ? new FTPSSessionReuseClient(this, this.ftpsMode.usesImplicitConnection(), this.context) : new FTPSClient(this.ftpsMode.usesImplicitConnection(), this.tlsContextFactory.createSslContext());
            this.ifNotEmpty(this.tlsContextFactory.getEnabledProtocols(), protocols -> client.setEnabledProtocols((String[])protocols));
            this.ifNotEmpty(this.tlsContextFactory.getEnabledCipherSuites(), ciphers -> client.setEnabledCipherSuites((String[])ciphers));
            return client;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create FTPS client"), (Throwable)e);
        }
    }

    public void mapSslSessionContextToSocketData(FTPSSessionReuseClient client, String hostDataPort, SSLSession session) {
        try {
            if (!this.clientSessionHostPortCache.cacheContainsKey(hostDataPort)) {
                this.clientSessionHostPortCache.cachePut(hostDataPort, session);
            }
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Object)e.getMessage());
        }
    }

    private void ifNotEmpty(String[] value, Consumer<String[]> consumer) {
        if (value != null && value.length != 0) {
            consumer.accept(value);
        }
    }

    protected ConnectionException handleClientReplyCode(int replyCode, Throwable cause) {
        if (cause instanceof SSLHandshakeException) {
            return new FTPConnectionException(this.getErrorMessage(replyCode, "SSL Handshake failed: " + cause.getMessage()), cause, FileError.INVALID_CREDENTIALS);
        }
        return super.handleClientReplyCode(replyCode, cause);
    }

    private class ClientSessionHostPortCache {
        private Object cache;
        private Method cacheGetMethod;
        private Method cachePutMethod;

        public ClientSessionHostPortCache(SSLSessionContext clientSessionContext) throws IllegalAccessException, NoSuchFieldException, NoSuchMethodException {
            Field sessionHostPortCache = clientSessionContext.getClass().getDeclaredField("sessionHostPortCache");
            if (!sessionHostPortCache.isAccessible()) {
                sessionHostPortCache.setAccessible(true);
            }
            this.cache = sessionHostPortCache.get(clientSessionContext);
            this.cacheGetMethod = this.cache.getClass().getDeclaredMethod("get", Object.class);
            this.cachePutMethod = this.cache.getClass().getDeclaredMethod("put", Object.class, Object.class);
            this.cacheGetMethod.setAccessible(true);
            this.cachePutMethod.setAccessible(true);
        }

        public boolean cacheContainsKey(String key) throws InvocationTargetException, IllegalAccessException {
            return this.cacheGetMethod.invoke(this.cache, key) != null;
        }

        public void cachePut(String key, SSLSession session) throws InvocationTargetException, IllegalAccessException {
            this.cachePutMethod.invoke(this.cache, key, session);
        }
    }
}

