/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.ftps.internal;

import com.mulesoft.extension.ftps.api.FtpsConnectionProvider;
import java.io.IOException;
import java.net.Socket;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.net.ftp.FTPSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPSSessionReuseClient
extends FTPSClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FTPSSessionReuseClient.class.getName());
    private FtpsConnectionProvider connectionProvider;

    public FTPSSessionReuseClient(FtpsConnectionProvider provider, boolean usesImplicitConnection, SSLContext sslContext) {
        super(usesImplicitConnection, sslContext);
        this.connectionProvider = provider;
    }

    protected void _prepareDataSocket_(Socket socket) throws IOException {
        if (socket instanceof SSLSocket) {
            SSLSession session = ((SSLSocket)this._socket_).getSession();
            if (session.isValid()) {
                LOGGER.debug("SSL SESSION VALID!");
                String port = String.valueOf(socket.getPort()).toLowerCase(Locale.ROOT);
                String hostNamePort = socket.getInetAddress().getHostName() + ":" + port;
                String hostAddressPort = socket.getInetAddress().getHostAddress() + ":" + port;
                try {
                    this.connectionProvider.mapSslSessionContextToSocketData(this, hostNamePort, session);
                    this.connectionProvider.mapSslSessionContextToSocketData(this, hostAddressPort, session);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            } else {
                LOGGER.warn("SSL session {} for socket {} is not rejoinable. Active connections may still exist, but they cannot join this session.", (Object)session, (Object)socket);
            }
        }
    }
}

