/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.ftps.internal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import org.apache.commons.net.ftp.FTPSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPSSessionReuseClient
extends FTPSClient {
    private static final boolean USE_EXTENDED_MASTER_SECRET = "true".equals(System.getProperty("jdk.tls.useExtendedMasterSecret"));
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FTPSSessionReuseClient.class.getName());
    private ClientSessionHostPortCache clientSessionHostPortCache;
    private String host;

    public FTPSSessionReuseClient(boolean usesImplicitConnection, SSLContext sslContext) throws ConnectException {
        super(usesImplicitConnection, sslContext);
        if (!USE_EXTENDED_MASTER_SECRET) {
            SSLSessionContext clientSessionContext = sslContext.getClientSessionContext();
            try {
                this.clientSessionHostPortCache = new ClientSessionHostPortCache(clientSessionContext);
            }
            catch (NoSuchFieldException e) {
                LOGGER.warn("No field 'sessionHostPortCache' in SSLSessionContext, cannot associate session to data connection for reuse. {}", (Object)e.getMessage());
            }
            catch (Exception e) {
                LOGGER.error("Could not create FTPS client", (Throwable)e);
                throw new ConnectException("Could not create FTPS client: " + e.getMessage());
            }
        }
    }

    protected void setHost(String host) {
        this.host = host;
    }

    protected void _prepareDataSocket_(Socket socket) throws IOException {
        if (!USE_EXTENDED_MASTER_SECRET && socket instanceof SSLSocket) {
            SSLSession session = ((SSLSocket)this._socket_).getSession();
            if (session.isValid()) {
                LOGGER.debug("SSL SESSION VALID!");
                String port = String.valueOf(socket.getPort()).toLowerCase(Locale.ROOT);
                String hostNamePort = socket.getInetAddress().getHostName() + ":" + port;
                String hostAddressPort = socket.getInetAddress().getHostAddress() + ":" + port;
                String hostPort = this.host + ":" + port;
                try {
                    this.mapSslSessionContextToSocketData(hostNamePort, session);
                    this.mapSslSessionContextToSocketData(hostAddressPort, session);
                    this.mapSslSessionContextToSocketData(hostPort, session);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Re-using session {} on port {}", (Object)session, (Object)hostAddressPort);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            } else {
                LOGGER.warn("SSL session {} for socket {} is not rejoinable. Active connections may still exist, but they cannot join this session.", (Object)session, (Object)socket);
            }
        }
    }

    public void mapSslSessionContextToSocketData(String hostDataPort, SSLSession session) {
        try {
            if (!this.clientSessionHostPortCache.cacheContainsKey(hostDataPort)) {
                this.clientSessionHostPortCache.cachePut(hostDataPort, session);
            }
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Object)e.getMessage());
        }
    }

    private class ClientSessionHostPortCache {
        private Object cache;
        private Method cacheGetMethod;
        private Method cachePutMethod;

        public ClientSessionHostPortCache(SSLSessionContext clientSessionContext) throws IllegalAccessException, NoSuchFieldException, NoSuchMethodException {
            Field sessionHostPortCache = clientSessionContext.getClass().getDeclaredField("sessionHostPortCache");
            if (!sessionHostPortCache.isAccessible()) {
                sessionHostPortCache.setAccessible(true);
            }
            this.cache = sessionHostPortCache.get(clientSessionContext);
            this.cacheGetMethod = this.cache.getClass().getDeclaredMethod("get", Object.class);
            this.cachePutMethod = this.cache.getClass().getDeclaredMethod("put", Object.class, Object.class);
            this.cacheGetMethod.setAccessible(true);
            this.cachePutMethod.setAccessible(true);
        }

        public boolean cacheContainsKey(String key) throws InvocationTargetException, IllegalAccessException {
            return this.cacheGetMethod.invoke(this.cache, key) != null;
        }

        public void cachePut(String key, SSLSession session) throws InvocationTargetException, IllegalAccessException {
            this.cachePutMethod.invoke(this.cache, key, session);
        }
    }
}

