/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.ftps.api;

import com.mulesoft.extension.ftps.api.mode.FtpsExplicitMode;
import com.mulesoft.extension.ftps.api.mode.FtpsMode;
import com.mulesoft.extension.ftps.api.proxy.ProxySettings;
import com.mulesoft.extension.ftps.api.util.FipsUtil;
import com.mulesoft.extension.ftps.internal.FTPSHTTPClient;
import com.mulesoft.extension.ftps.internal.FTPSSessionReuseClient;
import com.mulesoft.extension.ftps.internal.FtpsConnectionStereotype;
import java.security.Provider;
import java.security.Security;
import java.util.function.Consumer;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;
import org.mule.extension.ftp.api.FTPConnectionException;
import org.mule.extension.ftp.api.FileError;
import org.mule.extension.ftp.internal.connection.FtpAbstractConnectionProvider;
import org.mule.extension.ftp.internal.connection.FtpFileSystem;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="FTPS Connection")
@Summary(value="FTP Connection with support of SSL")
@Stereotype(value=FtpsConnectionStereotype.class)
public class FtpsConnectionProvider
extends FtpAbstractConnectionProvider
implements Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpsConnectionProvider.class);
    private final TlsContextFactoryBuilder tlsContextFactoryBuilder = TlsContextFactory.builder();
    @Parameter
    @Optional
    @Placement(tab="TLS", order=5)
    @DisplayName(value="TLS Configuration")
    private TlsContextFactory tlsContextFactory;
    @Parameter
    @Optional
    @Summary(value="Enables you to set HTTP or HTTPS tunnel proxy.")
    protected ProxySettings proxy;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @NullSafe(defaultImplementingType=FtpsExplicitMode.class)
    public FtpsMode ftpsMode;

    public void initialise() throws InitialisationException {
        if (!FipsUtil.isFipsEnabledEnvironment()) {
            Provider bcProvider = null;
            Provider bcJsseProvider = null;
            try {
                bcProvider = (Provider)FtpsConnectionProvider.class.getClassLoader().loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
                bcJsseProvider = (Provider)FtpsConnectionProvider.class.getClassLoader().loadClass("org.bouncycastle.jsse.provider.BouncyCastleJsseProvider").getConstructor(Boolean.TYPE, Provider.class).newInstance(false, bcProvider);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unable to register Bouncy Castle Providers. It'll be vulnerable to MITM Attack", (Object[])new Object[]{e}));
            }
            if (Security.getProvider("BC") != null) {
                Security.removeProvider("BC");
            }
            if (Security.getProvider("BCJSSE") != null) {
                Security.removeProvider("BCJSSE");
            }
            Security.insertProviderAt(bcProvider, 1);
            Security.insertProviderAt(bcJsseProvider, 2);
            LOGGER.info("Bouncy Castle providers registered!");
        } else {
            LOGGER.info("It is a FIPS environment!");
        }
        if (this.tlsContextFactory == null) {
            this.tlsContextFactory = this.tlsContextFactoryBuilder.buildDefault();
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
        LifecycleUtils.initialiseIfNeeded((Object)this.proxy);
    }

    public FtpFileSystem connect() throws ConnectionException {
        FtpFileSystem fileSystem = super.connect();
        this.ftpsMode.onAuthentication((FTPSClient)fileSystem.getClient());
        return fileSystem;
    }

    protected FTPClient createClient() {
        try {
            FTPSSessionReuseClient client;
            if (this.proxy == null) {
                client = new FTPSSessionReuseClient(this.ftpsMode.usesImplicitConnection(), this.tlsContextFactory.createSslContext());
            } else {
                client = new FTPSHTTPClient(this.proxy, this.ftpsMode.usesImplicitConnection(), this.tlsContextFactory.createSslContext());
                client.setUseEPSVwithIPv4(true);
                LOGGER.debug("Connecting to proxy host: '{}' at port: '{}'", (Object)this.proxy.getHost(), (Object)this.proxy.getPort());
            }
            if (LOGGER.isDebugEnabled()) {
                this.setupWireLogging((FTPClient)client, arg_0 -> ((Logger)LOGGER).debug(arg_0));
            }
            this.ifNotEmpty(this.tlsContextFactory.getEnabledProtocols(), protocols -> client.setEnabledProtocols((String[])protocols));
            this.ifNotEmpty(this.tlsContextFactory.getEnabledCipherSuites(), ciphers -> client.setEnabledCipherSuites((String[])ciphers));
            return client;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create FTPS client"), (Throwable)e);
        }
    }

    private void ifNotEmpty(String[] value, Consumer<String[]> consumer) {
        if (value != null && value.length != 0) {
            consumer.accept(value);
        }
    }

    protected ConnectionException handleClientReplyCode(int replyCode, Throwable cause) {
        if (cause instanceof SSLHandshakeException) {
            FTPConnectionException exception = new FTPConnectionException(this.getErrorMessage(replyCode, "SSL Handshake failed: " + cause.getMessage()), cause, FileError.INVALID_CREDENTIALS);
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            return exception;
        }
        ConnectionException connectionException = super.handleClientReplyCode(replyCode, cause);
        LOGGER.error(connectionException.getMessage(), (Throwable)connectionException);
        return connectionException;
    }
}

