/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.ftps.internal;

import com.mulesoft.extension.ftps.api.proxy.HttpsTunnelProxy;
import com.mulesoft.extension.ftps.api.proxy.ProxySettings;
import com.mulesoft.extension.ftps.internal.FTPSSessionReuseClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Inet6Address;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.net.ftp.FTPReply;
import org.mule.runtime.core.api.util.StringUtils;

public class FTPSHTTPClient
extends FTPSSessionReuseClient {
    private final ProxySettings proxy;
    protected SocketFactory proxySocketFactory;
    private SSLContext context;
    private SSLContext proxyContext;
    private static final byte[] CRLF = new byte[]{13, 10};
    private String tunnelHost;

    public FTPSHTTPClient(ProxySettings proxySettings, boolean isImplicit, SSLContext sslContext) throws KeyManagementException, NoSuchAlgorithmException {
        super(isImplicit, sslContext);
        this.proxy = proxySettings;
        this.tunnelHost = null;
        this.context = sslContext;
        if (this.proxy instanceof HttpsTunnelProxy && ((HttpsTunnelProxy)this.proxy).getTlsContextFactory() != null) {
            this.proxyContext = ((HttpsTunnelProxy)this.proxy).getTlsContextFactory().createSslContext();
        }
    }

    @Deprecated
    protected Socket _openDataConnection_(int command, String arg) throws IOException {
        return super._openDataConnection_(command, arg);
    }

    protected Socket _openDataConnection_(String command, String arg) throws IOException {
        boolean attemptEPSV;
        if (this.getDataConnectionMode() != 2) {
            throw new IllegalStateException("Only passive connection mode supported");
        }
        boolean isInet6Address = this.getRemoteAddress() instanceof Inet6Address;
        String passiveHost = null;
        boolean bl = attemptEPSV = this.isUseEPSVwithIPv4() || isInet6Address;
        if (attemptEPSV && this.epsv() == 229) {
            this._parseExtendedPassiveModeReply((String)this._replyLines.get(0));
            passiveHost = this.tunnelHost;
        } else {
            if (isInet6Address) {
                return null;
            }
            if (this.pasv() != 227) {
                return null;
            }
            this._parsePassiveModeReply((String)this._replyLines.get(0));
            passiveHost = this.getPassiveHost();
        }
        Socket socket = this.proxySocketFactory.createSocket(this.proxy.getHost(), this.proxy.getPort());
        try {
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            this.tunnelHandshake(passiveHost, this.getPassivePort(), is, os);
            Socket sslSocket = this.sslNegotiation(socket);
            if (!this.validateDataConnection(command, arg)) {
                socket.close();
                return null;
            }
            this._prepareDataSocket_(sslSocket);
            return sslSocket;
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (IOException closeEx) {
                e.addSuppressed(closeEx);
            }
            throw e;
        }
    }

    public void connect(String host, int port) throws IOException {
        BufferedReader socketIsReader;
        this.proxySocketFactory = this.proxy instanceof HttpsTunnelProxy ? this.proxyContext.getSocketFactory() : this._socketFactory_;
        this._socket_ = this.proxySocketFactory.createSocket(this.proxy.getHost(), this.proxy.getPort());
        this._input_ = this._socket_.getInputStream();
        this._output_ = this._socket_.getOutputStream();
        try {
            socketIsReader = this.tunnelHandshake(host, port, this._input_, this._output_);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Could not connect to " + host + " using port " + port);
            ioe.initCause(e);
            throw ioe;
        }
        super._connectAction_((Reader)socketIsReader);
        this.execAUTH();
        this.sslNegotiation();
    }

    private BufferedReader tunnelHandshake(String host, int port, InputStream input, OutputStream output) throws IOException {
        String connectString = "CONNECT " + host + ":" + port + " HTTP/1.1";
        String hostString = "Host: " + host + ":" + port;
        this.tunnelHost = host;
        output.write(connectString.getBytes(StandardCharsets.UTF_8));
        output.write(CRLF);
        output.write(hostString.getBytes(StandardCharsets.UTF_8));
        output.write(CRLF);
        if (!StringUtils.isEmpty((String)this.proxy.getUsername()) && !StringUtils.isEmpty((String)this.proxy.getPassword())) {
            String auth = this.proxy.getUsername() + ":" + this.proxy.getPassword();
            String header = "Proxy-Authorization: Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8)) + "\r\n";
            output.write(header.getBytes(StandardCharsets.UTF_8));
        }
        output.write(CRLF);
        ArrayList<String> response = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, this.getCharset()));
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            response.add(line);
            line = reader.readLine();
        }
        int size = response.size();
        if (size == 0) {
            throw new IOException("No response from proxy");
        }
        String code = null;
        String resp = (String)response.get(0);
        if (!resp.startsWith("HTTP/") || resp.length() < 12) {
            throw new IOException("Invalid response from proxy: " + resp);
        }
        code = resp.substring(9, 12);
        if (!"200".equals(code)) {
            StringBuilder msg = new StringBuilder();
            msg.append("HTTPTunnelConnector: connection failed\r\n");
            msg.append("Response received from the proxy:\r\n");
            for (String line2 : response) {
                msg.append(line2);
                msg.append("\r\n");
            }
            throw new IOException(msg.toString());
        }
        return reader;
    }

    private Socket sslNegotiation(Socket socket) throws IOException {
        SSLSocketFactory ssf = this.context.getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)ssf.createSocket(socket, this.tunnelHost, this.getPassivePort(), false);
        sslSocket.setEnableSessionCreation(true);
        sslSocket.setUseClientMode(true);
        return sslSocket;
    }

    private boolean validateDataConnection(String command, String arg) throws IOException {
        if (this.getRestartOffset() > 0L && !this.restart(this.getRestartOffset())) {
            return false;
        }
        return FTPReply.isPositivePreliminary((int)this.sendCommand(command, arg));
    }
}

