/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.ftps.internal;

import com.mulesoft.extension.ftps.api.exception.SSLSessionResumptionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.Security;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.net.ftp.FTPSClient;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPSSessionReuseClient
extends FTPSClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(FTPSSessionReuseClient.class);
    private static final String TLS_CLIENT_PROTOCOLS = "jdk.tls.client.protocols";
    private static final String BC_SSL_SOCKET_CLASSNAME = "org.bouncycastle.jsse.BCSSLSocket";
    private static final String BC_EXTENDED_SSL_SESSION_CLASSNAME = "org.bouncycastle.jsse.BCExtendedSSLSession";

    public FTPSSessionReuseClient(boolean usesImplicitConnection, SSLContext sslContext) {
        super(usesImplicitConnection, sslContext);
    }

    protected void _connectAction_() throws IOException {
        String clientProtocols = System.getProperty(TLS_CLIENT_PROTOCOLS);
        if (!StringUtils.isEmpty((String)clientProtocols)) {
            LOGGER.debug("Setting TLS Client Protocol Version: {}", (Object)clientProtocols);
            this.setEnabledProtocols(this.trimUnwantedWhitespace(clientProtocols));
        }
        super._connectAction_();
    }

    private String[] trimUnwantedWhitespace(String value) {
        return (String[])Arrays.stream(value.split(",")).map(String::trim).toArray(String[]::new);
    }

    protected void _prepareDataSocket_(Socket dataSocket) {
        block6: {
            if (!this.bcSocketClassesLoaded()) {
                return;
            }
            LOGGER.info("BouncyCastle provider impl found!");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registered security providers providers: {}", (Object)Arrays.stream(Security.getProviders()).map(provider -> provider.getName() + ",").collect(Collectors.joining()));
            }
            try {
                Class<?> bcSSLSocket = this._socket_.getClass().getClassLoader().loadClass(BC_SSL_SOCKET_CLASSNAME);
                if (bcSSLSocket.isInstance(this._socket_)) {
                    LOGGER.debug("Socket object is BCSSLSocket type");
                    Method method = bcSSLSocket.getMethod("getBCSession", new Class[0]);
                    SSLSession bcSession = (SSLSession)method.invoke((Object)this._socket_, new Object[0]);
                    if (bcSession != null && bcSession.isValid() && bcSSLSocket.isInstance(dataSocket)) {
                        LOGGER.info("Resuming SSL/TLS Session");
                        Class<?> bcExtendedSSLSession = this._socket_.getClass().getClassLoader().loadClass(BC_EXTENDED_SSL_SESSION_CLASSNAME);
                        Method setBCSessionToResume = bcSSLSocket.getMethod("setBCSessionToResume", bcExtendedSSLSession);
                        setBCSessionToResume.invoke((Object)dataSocket, bcSession);
                        Method setHost = bcSSLSocket.getMethod("setHost", String.class);
                        setHost.invoke((Object)dataSocket, bcSession.getPeerHost());
                    }
                    break block6;
                }
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Socket object is not a BCSSLSocket type, it'll be vulnerable to MITM Attack"));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new SSLSessionResumptionException("Failed to resume SSL/TLS session due to reflection error", e);
            }
        }
    }

    private boolean bcSocketClassesLoaded() {
        try {
            this._socket_.getClass().getClassLoader().loadClass(BC_EXTENDED_SSL_SESSION_CLASSNAME);
            this._socket_.getClass().getClassLoader().loadClass(BC_SSL_SOCKET_CLASSNAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("BouncyCastle provider impl not found!");
            LOGGER.warn("Session reuse not possible, vulnerable to MITM Attack");
            return false;
        }
    }
}

