/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.hl7.extension.internal.config;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.hl7.UsageKludge;
import com.mulesoft.connectors.hl7.extension.internal.connection.Provider;
import com.mulesoft.connectors.hl7.extension.internal.exception.SchemaException;
import com.mulesoft.connectors.hl7.extension.internal.param.DocumentParams;
import com.mulesoft.connectors.hl7.extension.internal.param.IdentityParams;
import com.mulesoft.connectors.hl7.extension.internal.param.ParserParams;
import com.mulesoft.connectors.hl7.extension.internal.param.WriterParams;
import com.mulesoft.flatfile.schema.hl7.HL7FormConverter$;
import com.mulesoft.flatfile.schema.hl7.HL7SchemaDefs;
import com.mulesoft.flatfile.schema.model.EdiFormConverter;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.ReferenceComponent;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.model.StructureComponent;
import com.mulesoft.flatfile.schema.model.StructureSequence;
import com.mulesoft.flatfile.schema.tools.YamlSupport;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import com.mulesoft.flatfile.schema.yaml.YamlReader$;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import scala.Tuple2;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.immutable.List;

@ConnectionProviders(value={Provider.class})
@Operations(value={com.mulesoft.connectors.hl7.extension.internal.operation.Operations.class})
@Configuration(name="config")
public class Config
implements ConnectorConfig,
Startable {
    static final String HL7_PREFIX = "/hl7/";
    static final String DEFAULT_ACK_PATH = "/hl7/v2_5_1/ACK.esl";
    @ParameterGroup(name="Identity")
    private IdentityParams identityParams;
    @ParameterGroup(name="Document")
    private DocumentParams documentParams;
    @ParameterGroup(name="Parser")
    private ParserParams parserParams;
    @ParameterGroup(name="Writer")
    private WriterParams writerParams;
    private java.util.Map<String, Object> eventStructures;
    private java.util.Map<String, Structure> structDefs;
    private Segment mshSegment;
    private String mshSegmentKey;
    private Structure ackStructure;
    private static final String HL7 = "HL7";
    private static final String ACK = "ACK";

    public IdentityParams getIdentityParams() {
        return this.identityParams;
    }

    public DocumentParams getDocumentParams() {
        return this.documentParams;
    }

    public void setDocumentParams(DocumentParams documentParams) {
        this.documentParams = documentParams;
    }

    public WriterParams getWriterParams() {
        return this.writerParams;
    }

    public ParserParams getParserParams() {
        return this.parserParams;
    }

    private EdiSchema loadAndVerifySchema(String path, YamlReader yamlrdr) {
        EdiSchema schema;
        YamlReader.InputSource source;
        try {
            source = YamlReader$.MODULE$.findSchema(path);
        }
        catch (Exception t) {
            throw new SchemaException("Schema not found " + path, t);
        }
        try {
            InputStreamReader reader = new InputStreamReader(source.input(), StandardCharsets.UTF_8);
            schema = this.getSchema(reader, (List<String>)source.prefixPaths(), yamlrdr, this.documentParams.isIdentKeys());
        }
        catch (Exception t) {
            throw new SchemaException("Error loading schema from path " + path, t);
        }
        String ediForm = schema.ediVersion().ediForm().text();
        if (!HL7.equals(ediForm)) {
            throw new SchemaException("EDI format " + schema.ediVersion().ediForm() + " is not compatible with HL7");
        }
        return schema;
    }

    private EdiSchema getSchema(InputStreamReader reader, List<String> paths, YamlReader yamlReader, boolean isIdentKeys) {
        yamlReader.setCheckIdRef(false);
        return yamlReader.loadYaml((Reader)reader, paths, isIdentKeys);
    }

    public void start() throws MuleException {
        this.mshSegment = null;
        this.ackStructure = null;
        this.structDefs = new HashMap<String, Structure>();
        YamlReader yamlrdr = new YamlReader((EdiFormConverter)HL7FormConverter$.MODULE$);
        for (String path : this.documentParams.getSchemas()) {
            this.messageStructFromConfig(path, yamlrdr, this.structDefs);
            if (this.structDefs.size() != 0) continue;
            throw new SchemaException("Missing message structure schema definition(s) in configuration");
        }
        if (this.mshSegment == null) {
            throw new SchemaException("No schema definition includes MSH segment definition");
        }
        if (this.ackStructure == null) {
            this.ackStructure = (Structure)((Tuple2)this.loadAndVerifySchema((String)DEFAULT_ACK_PATH, (YamlReader)yamlrdr).structures().head())._2;
        }
        String mapPath = this.getMapPath();
        UsageKludge.kludge();
    }

    private void messageStructFromConfig(String path, YamlReader yamlReader, java.util.Map<String, Structure> structDefs) {
        EdiSchema schema = this.loadAndVerifySchema(path, yamlReader);
        JavaConverters.mapAsJavaMap((Map)schema.structures()).forEach((ident, struct) -> {
            StructureComponent head;
            if (structDefs.put((String)ident, (Structure)struct) != null) {
                throw new SchemaException("Multiple structure definitions found for message structure " + ident);
            }
            if (this.mshSegment == null && (head = (StructureComponent)((StructureSequence)struct.heading().get()).items().head()) instanceof ReferenceComponent && HL7SchemaDefs.mshKey().equals(((ReferenceComponent)head).segment().tag())) {
                ReferenceComponent mshReferenceComponent = (ReferenceComponent)head;
                this.mshSegment = mshReferenceComponent.segment();
                this.mshSegmentKey = mshReferenceComponent.key();
            }
            this.defineAckStructure((Structure)struct);
        });
    }

    private void defineAckStructure(Structure struct) {
        if (ACK.equals(struct.ident())) {
            if (this.ackStructure == null) {
                this.ackStructure = struct;
            } else {
                throw new SchemaException("Only one ACK structure definition allowed");
            }
        }
    }

    private String getMapPath() {
        String mapPath = this.getDocumentParams().getEventMessageMap();
        if (mapPath != null && !mapPath.isEmpty()) {
            InputStream is = YamlReader$.MODULE$.findSchema(mapPath).input();
            this.eventStructures = YamlSupport.readMap((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        return mapPath;
    }

    public java.util.Map<String, Object> getEventStructures() {
        return this.eventStructures;
    }

    public java.util.Map<String, Structure> getStructDefs() {
        return this.structDefs;
    }

    public Segment getMshSegment() {
        return this.mshSegment;
    }

    public Structure getAckStructure() {
        return this.ackStructure;
    }

    public String getMshSegmentKey() {
        return this.mshSegmentKey;
    }
}

