/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.hl7.extension.internal.metadata;

import com.mulesoft.connectors.hl7.extension.internal.config.Config;
import com.mulesoft.flatfile.schema.SchemaJavaValues;
import com.mulesoft.flatfile.schema.hl7.HL7$;
import com.mulesoft.flatfile.schema.hl7.HL7Error;
import com.mulesoft.flatfile.schema.hl7.HL7SchemaDefs;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.Structure;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.flatfile.metadata.schema.StructureHandler;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;

public class ConnectorTypeLoader
implements TypeLoader {
    public static final MetadataFormat HL7 = new MetadataFormat("HL7", "hl7", new String[]{"application/text"});
    public static final String INPUT_IDENTIFIER = "write";
    public static final String OUTPUT_IDENTIFIER = "read";
    private final Segment mshSegment;
    private final Structure ackStructure;
    private final Map<String, Structure> structDefs;

    private ConnectorTypeLoader(Segment msh, Structure ack, Map<String, Structure> structs) {
        this.mshSegment = msh;
        this.ackStructure = ack;
        this.structDefs = structs;
    }

    public static MetadataType getMetadata(MetadataContext context, String form) throws MetadataResolvingException {
        Config config = (Config)context.getConfig().orElseThrow(() -> new MetadataResolvingException("No configuration supplied for metadata generation", FailureCode.INVALID_CONFIGURATION));
        try {
            config.start();
        }
        catch (MuleException e) {
            throw new MetadataResolvingException("Error calling configuration start()", FailureCode.INVALID_CONFIGURATION, (Throwable)e);
        }
        Optional<MetadataType> opttype = new ConnectorTypeLoader(config.getMshSegment(), config.getAckStructure(), config.getStructDefs()).load(form);
        return opttype.orElseThrow(() -> new MetadataResolvingException("Unable to create metadata", FailureCode.INVALID_CONFIGURATION));
    }

    public Optional<MetadataType> load(String identifier) {
        return this.load(identifier, null);
    }

    private void addRequiredField(ObjectTypeBuilder parent, String key, String text, MetadataType typ) {
        parent.addField().required().key(key).description(text).value(typ);
    }

    public Optional<MetadataType> load(String identifier, String typeAlias) {
        BaseTypeBuilder baseBuilder = new BaseTypeBuilder(HL7);
        ObjectTypeBuilder root = baseBuilder.objectType();
        DefaultStringType typ = baseBuilder.stringType().length(Integer.valueOf(4)).build();
        this.addRequiredField(root, SchemaJavaValues.delimiterCharacters(), "Delimiter characters", (MetadataType)typ);
        typ = baseBuilder.stringType().boundary((Number)3, (Number)7).build();
        this.addRequiredField(root, SchemaJavaValues.structureId(), "Message structure identifier", (MetadataType)typ);
        if (OUTPUT_IDENTIFIER.equals(identifier)) {
            typ = baseBuilder.stringType().build();
            this.addRequiredField(root, SchemaJavaValues.structureName(), "Message structure name", (MetadataType)typ);
        }
        ObjectFieldTypeBuilder fieldBuilder = root.addField();
        fieldBuilder.key("Data").required();
        ObjectTypeBuilder dataBuilder = fieldBuilder.value().objectType();
        Object[] keys = this.structDefs.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StructureHandler structHandler = new StructureHandler(HL7, (EdiForm)HL7$.MODULE$, Collections.emptyMap());
        for (Object key : keys) {
            Structure struct = this.structDefs.get(key);
            ObjectFieldTypeBuilder structField = dataBuilder.addField();
            structField.key(struct.ident());
            structHandler.buildStructure(struct, true, structField.value().objectType());
        }
        fieldBuilder.description("Message data");
        if (OUTPUT_IDENTIFIER.equals(identifier)) {
            fieldBuilder = root.addField();
            structHandler.buildSegment(this.mshSegment, fieldBuilder);
            fieldBuilder.key(HL7SchemaDefs.mshKey()).required().description("MSH segment data (also linked in message data)");
            fieldBuilder = root.addField();
            fieldBuilder.required().key(this.ackStructure.ident()).description("Generated acknowledgment");
            StructureHandler ackHandler = new StructureHandler(HL7, (EdiForm)HL7$.MODULE$, Collections.emptyMap());
            ackHandler.buildStructure(this.ackStructure, false, fieldBuilder.value().objectType());
            fieldBuilder = root.addField();
            fieldBuilder.required().key(SchemaJavaValues.errorListKey()).description("Errors and warnings found during parsing");
            JavaTypeLoader loader = new JavaTypeLoader(this.getClass().getClassLoader());
            fieldBuilder.value().arrayType().of(loader.load(HL7Error.class));
        }
        MetadataTypeUtils.addTypeAlias((TypeBuilder)root, (String)typeAlias);
        return Optional.of(root.build());
    }
}

