/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.hl7.extension.internal.service;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.mulesoft.connectors.commons.template.service.DefaultConnectorService;
import com.mulesoft.connectors.hl7.extension.api.config.ProcessingId;
import com.mulesoft.connectors.hl7.extension.internal.config.Config;
import com.mulesoft.connectors.hl7.extension.internal.connection.Connection;
import com.mulesoft.connectors.hl7.extension.internal.exception.ParseException;
import com.mulesoft.connectors.hl7.extension.internal.exception.WriteException;
import com.mulesoft.connectors.hl7.extension.internal.param.DocumentParams;
import com.mulesoft.connectors.hl7.extension.internal.param.IdentityParams;
import com.mulesoft.connectors.hl7.extension.internal.param.ParserParams;
import com.mulesoft.connectors.hl7.extension.internal.param.WriterParams;
import com.mulesoft.connectors.hl7.extension.internal.service.Service;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.schema.SchemaJavaValues;
import com.mulesoft.flatfile.schema.SchemaJavaValues$;
import com.mulesoft.flatfile.schema.hl7.HL7EnvelopeHandler;
import com.mulesoft.flatfile.schema.hl7.HL7Identity;
import com.mulesoft.flatfile.schema.hl7.HL7NumberProvider;
import com.mulesoft.flatfile.schema.hl7.HL7ParserConfig;
import com.mulesoft.flatfile.schema.hl7.HL7SchemaDefs;
import com.mulesoft.flatfile.schema.hl7.HL7SchemaParser;
import com.mulesoft.flatfile.schema.hl7.HL7SchemaWriter;
import com.mulesoft.flatfile.schema.hl7.HL7WriterConfig;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.Structure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import scala.Option;
import scala.util.Try;

public class ServiceImpl
extends DefaultConnectorService<Config, Connection>
implements Service {
    static final String IDENT_NOT_SET_ERR = "Missing required '" + SchemaJavaValues$.MODULE$.structureId() + "' value in message payload.";
    static final String STRUCTURE_LOAD_ERR = "Could not load message structure ";
    static final String MSH_LOAD_ERR = "Could not retrieve the MSH segment from the payload";
    static final String DATA_NOT_SET_ERR = "Missing required '" + SchemaJavaValues$.MODULE$.dataKey() + "' value in message payload.";
    static final String STRUCTURE_DATA_MISSING_ERR = "No data found for specified structure id.";
    static final String STRUCTURE_NOTFOUND_ERR = "No message structure found in eventMessageMap for message ";
    static final String MSG_PROCESSING_ID_ERR = "Message processing ID does not match configured value: ";
    static final String MSG_UNCONFIG_MSG_STRUCTURE_ERR = "Unconfigured message structure: ";
    static final String MSG_MISSING_MSG_STRUCTURE_ERR = "Receive message missing message structure value";
    static final String MSG_EVENTSTRUCT_ERR = "Need eventMessageMap to identify message structure for message ";
    static final String INVALID_DELIMITER_ERR = "Invalid delimiter character: '";
    static final String DUPLICATE_DELIMITER_ERR = "Duplicate delimiter character: '";
    static final String DELIMITERS_NO_ERR = SchemaJavaValues.delimiterCharacters() + " value must be 5 characters. Found: '";
    static final String ACK = "ACK";

    public ServiceImpl(Config config, Connection connection) {
        super((ConnectorConfig)config, (ConnectorConnection)connection);
    }

    @Override
    public Map<String, Object> read(InputStream readContent) {
        Try parsed;
        IdentityParams identity = ((Config)this.getConfig()).getIdentityParams();
        HL7Identity.HierarchicDesignator appSelf = new HL7Identity.HierarchicDesignator(identity.getAppNamespaceIdSelf(), identity.getAppUniversalIdSelf(), identity.getAppUniversalIdTypeSelf());
        HL7Identity.HL7IdentityInformation selfId = new HL7Identity.HL7IdentityInformation(appSelf, new HL7Identity.HierarchicDesignator(null, null, null));
        HL7Identity.HierarchicDesignator appPartner = new HL7Identity.HierarchicDesignator(identity.getAppNamespaceIdPartner(), identity.getAppUniversalIdPartner(), identity.getAppUniversalIdTypePartner());
        HL7Identity.HL7IdentityInformation partnerId = new HL7Identity.HL7IdentityInformation(appPartner, new HL7Identity.HierarchicDesignator(null, null, null));
        final ParserParams parser = ((Config)this.getConfig()).getParserParams();
        String extenMatch = parser.getGenericExtensionPattern();
        if (extenMatch == null) {
            extenMatch = "";
        }
        Pattern pattern = Pattern.compile(extenMatch);
        HL7ParserConfig parserConfig = new HL7ParserConfig(parser.isValueLengthErrorFail(), parser.isInvalidCharacterInValueFail(), parser.isWrongValuesRepeatsFail(), parser.isUnknownSegmentFail(), parser.isSegmentOutOfOrderFail(), parser.isUnusedSegmentPresentFail(), parser.isWrongSegmentsRepeatsFail(), parser.isMissingRequiredValueFail(), -1, pattern, ((Config)this.getConfig()).getAckStructure(), ((Config)this.getConfig()).getMshSegment(), new HL7Identity.HL7IdentityInformation[]{selfId}, new HL7Identity.HL7IdentityInformation[]{partnerId}, parser.getSegmentTerminator().segmentTerminator);
        DocumentParams document = ((Config)this.getConfig()).getDocumentParams();
        final Map<String, Structure> structDefs = ((Config)this.getConfig()).getStructDefs();
        try {
            parsed = new HL7SchemaParser(readContent, document.getCharacterEncoding().characterSet, new HL7EnvelopeHandler(){

                public Structure handleMsh(Map data) throws LexicalException {
                    Option optid;
                    ProcessingId procId = parser.getProcessingId();
                    if (procId != null) {
                        Map procIdMap = (Map)data.get(HL7SchemaDefs.msgProcessingIDKey());
                        if (procIdMap == null || !procIdMap.containsKey(HL7SchemaDefs.ptProcessingIdKey())) {
                            throw new LexicalException("Message processing ID does not match configured value: <none>");
                        }
                        String msgProcId = procIdMap.get(HL7SchemaDefs.ptProcessingIdKey()).toString();
                        if (!procId.idValue.equals(msgProcId)) {
                            throw new LexicalException(ServiceImpl.MSG_PROCESSING_ID_ERR + msgProcId);
                        }
                    }
                    if (structDefs.size() == 1) {
                        return (Structure)structDefs.values().iterator().next();
                    }
                    Map<String, Object> eventstructs = ((Config)ServiceImpl.this.getConfig()).getEventStructures();
                    if (eventstructs == null) {
                        eventstructs = Collections.emptyMap();
                    }
                    if ((optid = this.getMessageStructure(data, eventstructs, ((Config)ServiceImpl.this.getConfig()).getMshSegment())).isDefined()) {
                        String ident = (String)optid.get();
                        if (ServiceImpl.ACK.equals(ident)) {
                            return ((Config)ServiceImpl.this.getConfig()).getAckStructure();
                        }
                        Structure struct = ((Config)ServiceImpl.this.getConfig()).getStructDefs().get(ident);
                        if (struct == null) {
                            throw new LexicalException(ServiceImpl.STRUCTURE_LOAD_ERR + ident);
                        }
                        return struct;
                    }
                    Map msgType = (Map)data.get(HL7SchemaDefs.mshMessageTypeKey());
                    String descript = "<missing message type information>";
                    if (msgType != null) {
                        descript = msgType.get(HL7SchemaDefs.msgMessage((Segment)((Config)ServiceImpl.this.getConfig()).getMshSegment())) + "/" + msgType.get(HL7SchemaDefs.msgTrigger((Segment)((Config)ServiceImpl.this.getConfig()).getMshSegment()));
                    }
                    if (((Config)ServiceImpl.this.getConfig()).getEventStructures() == null) {
                        throw new LexicalException(ServiceImpl.MSG_EVENTSTRUCT_ERR + descript);
                    }
                    throw new LexicalException(ServiceImpl.STRUCTURE_NOTFOUND_ERR + descript);
                }
            }, parserConfig).parse();
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), exception);
        }
        return (Map)parsed.get();
    }

    private Structure retrieveMessageStructure(Map<String, Object> message) {
        String ident = (String)message.get(SchemaJavaValues$.MODULE$.structureId());
        if (ident == null) {
            throw new WriteException(IDENT_NOT_SET_ERR);
        }
        if (ACK.equals(ident)) {
            return ((Config)this.getConfig()).getAckStructure();
        }
        Map<String, Structure> structDefs = ((Config)this.getConfig()).getStructDefs();
        Structure structure = structDefs.get(ident);
        if (structure == null) {
            throw new WriteException(STRUCTURE_LOAD_ERR + ident);
        }
        return structure;
    }

    private String validateMessageNumber(Map<String, Object> mshSegment) {
        String messageNumber = (String)mshSegment.get("MSH-10");
        if (messageNumber == null || messageNumber.isEmpty()) {
            messageNumber = "0";
        }
        return messageNumber;
    }

    private String getDelimiters(Map<String, Object> message) {
        String delimiters = (String)message.get(SchemaJavaValues.delimiterCharacters());
        WriterParams params = ((Config)this.getConfig()).getWriterParams();
        if (delimiters == null) {
            delimiters = params.getFieldSeparator() + params.getComponentSeparator() + params.getRepetitionSeparator() + params.getEscapeCharacter() + params.getSubcompSeparator();
        }
        ServiceImpl.validateDelimiters(delimiters);
        return delimiters;
    }

    public static void validateDelimiters(String delimiters) {
        if (delimiters.length() != 5) {
            throw new WriteException(DELIMITERS_NO_ERR + delimiters + "'");
        }
        HashSet<Character> chars = new HashSet<Character>();
        for (int i = 0; i < 5; ++i) {
            char delim = delimiters.charAt(i);
            if ((Character.isAlphabetic(delim) || Character.isDigit(delim)) && (i != 2 || delim != '\u0000')) {
                throw new WriteException(INVALID_DELIMITER_ERR + delim + "'");
            }
            if (chars.add(Character.valueOf(delim))) continue;
            throw new WriteException(DUPLICATE_DELIMITER_ERR + delim + "'");
        }
    }

    @Override
    public InputStream write(Map<String, Object> writeContent) {
        Structure struct = this.retrieveMessageStructure(writeContent);
        Map data = (Map)writeContent.get(SchemaJavaValues$.MODULE$.dataKey());
        if (data == null) {
            throw new WriteException(DATA_NOT_SET_ERR);
        }
        Map msg = (Map)data.get(struct.ident());
        if (msg == null) {
            throw new WriteException(STRUCTURE_DATA_MISSING_ERR);
        }
        Map msh = (Map)msg.get(((Config)this.getConfig()).getMshSegmentKey());
        if (msh == null) {
            throw new WriteException(MSH_LOAD_ERR);
        }
        final String msgNumber = this.validateMessageNumber(msh);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String delims = this.getDelimiters(writeContent);
        HL7WriterConfig config = new HL7WriterConfig(false, -1, ((Config)this.getConfig()).getDocumentParams().getCharacterEncoding().characterSet, delims, ((Config)this.getConfig()).getMshSegment(), ((Config)this.getConfig()).getWriterParams().getSegmentTerminator().segmentTerminator, ((Config)this.getConfig()).getWriterParams().isHandleEmptyArrays());
        HL7SchemaWriter writer = new HL7SchemaWriter((OutputStream)bos, struct, new HL7NumberProvider(){

            public String nextMessage(HL7Identity.HL7IdentityInformation sender, HL7Identity.HL7IdentityInformation receiver) {
                return msgNumber;
            }
        }, config);
        writer.write(writeContent).get();
        return new ByteArrayInputStream(bos.toByteArray());
    }
}

