/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ibmctg.internal.connection;

import com.ibm.connector2.cics.ECIManagedConnectionFactory;
import com.ibm.ctg.client.T;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.LocalTransaction;
import javax.transaction.xa.XAResource;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.modules.ibmctg.api.ChannelRequest;
import org.mule.modules.ibmctg.internal.config.CTGConfig;
import org.mule.modules.ibmctg.internal.connection.CTGConnectionProfile;
import org.mule.modules.ibmctg.internal.exception.CTGResourceException;
import org.mule.modules.ibmctg.internal.exception.CTGTransactionException;
import org.mule.modules.ibmctg.internal.exception.ValidationException;
import org.mule.modules.ibmctg.internal.service.CTGServiceImpl;
import org.mule.modules.ibmctg.internal.service.xa.ResourceAdapterUtils;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTGConnection
implements ConnectorConnection,
TransactionalConnection,
XATransactionalConnection {
    private static final Logger logger = LoggerFactory.getLogger(CTGConnection.class);
    private CTGConnectionProfile ctgConnectionProfile;
    private ConnectionFactory connectionFactory;
    private Connection client;

    public CTGConnection(CTGConnectionProfile ctgConnectionProfile) throws ResourceException {
        this.ctgConnectionProfile = ctgConnectionProfile;
        this.initConnectionFactory();
        this.setClient(this.getBoundConnection(null));
    }

    public Connection getClient() {
        return this.client;
    }

    public void setClient(Connection client) {
        this.client = client;
    }

    public CTGConnectionProfile getCtgConnectionProfile() {
        return this.ctgConnectionProfile;
    }

    public Connection getClient(ConnectionSpec connectionSpec) throws ResourceException {
        return Optional.ofNullable(this.client).orElse(Optional.ofNullable(connectionSpec).isPresent() ? this.getConnectionFactory().getConnection(connectionSpec) : this.getConnectionFactory().getConnection());
    }

    private ConnectionFactory initConnectionFactory() throws ResourceException {
        if (this.connectionFactory == null) {
            if (this.getCtgConnectionProfile().isCtgTrace()) {
                T.setDebugOn((boolean)true);
                T.setfullDataDumpOn((boolean)true);
            }
            ECIManagedConnectionFactory managedFactory = new ECIManagedConnectionFactory();
            managedFactory.setConnectionURL(this.getCtgConnectionProfile().isLocal() ? "local:" : this.getCtgConnectionProfile().getCtgURL());
            logger.debug(String.format("Acquiring client to %s on port %s", this.getCtgConnectionProfile().getCtgURL(), this.getCtgConnectionProfile().getPort()));
            if (this.getCtgConnectionProfile().isSecure()) {
                managedFactory.setKeyRingClass(this.getCtgConnectionProfile().getKeyStore());
                managedFactory.setKeyRingPassword(this.getCtgConnectionProfile().getKeyStorePassword());
            }
            managedFactory.setPortNumber(String.valueOf(this.getCtgConnectionProfile().getPort()));
            managedFactory.setServerName(this.getCtgConnectionProfile().getServerName());
            managedFactory.setUserName(this.getCtgConnectionProfile().getUserName());
            managedFactory.setPassword(this.getCtgConnectionProfile().getPassword());
            managedFactory.setXaSupport("on");
            if (this.getCtgConnectionProfile().getConnectionTimeout() > 0) {
                managedFactory.setSocketConnectTimeout(String.valueOf(this.getCtgConnectionProfile().getConnectionTimeout()));
            }
            this.setConnectionFactory((ConnectionFactory)managedFactory.createConnectionFactory());
        }
        return this.connectionFactory;
    }

    private Connection getBoundConnection(ConnectionSpec connectionSpec) {
        try {
            return this.getClient(connectionSpec);
        }
        catch (ResourceException e) {
            throw new CTGResourceException(e);
        }
    }

    private ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    private void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void disconnect() {
        try {
            this.client.close();
        }
        catch (ResourceException e) {
            logger.warn("Connection could not be closed", (Throwable)e);
        }
    }

    public void begin() throws TransactionException {
        try {
            LocalTransaction trx = this.client.getLocalTransaction();
            if (trx != null) {
                logger.info("found local transaction - " + trx.toString());
                trx.begin();
                logger.info("started / joined transaction");
            } else {
                logger.info("no transaction found");
            }
        }
        catch (ResourceException e) {
            throw new CTGTransactionException(e);
        }
    }

    public void validate() {
        try {
            ChannelRequest request = new ChannelRequest();
            request.setProgramName("EC03");
            request.setTpnName("CSMI");
            request.setEncoding("US-ASCII");
            request.setChannel("EC03CHANNEL");
            request.setRequestContainer("INPUTDATA");
            request.setResponseContainer("CICSDATETIME");
            request.setErrorContainer("OUTPUTMESSAGE");
            new CTGServiceImpl(new CTGConfig(), this).execute(new ByteArrayInputStream("test".getBytes(Charset.forName(request.getEncoding()))), request);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e);
        }
    }

    public void commit() throws TransactionException {
        try {
            LocalTransaction trx = this.client.getLocalTransaction();
            if (trx != null) {
                logger.info("committing transaction - " + trx.toString());
                trx.commit();
                logger.info("done.");
            } else {
                logger.info("no transaction found");
            }
        }
        catch (ResourceException e) {
            throw new CTGTransactionException(e);
        }
    }

    public void rollback() throws TransactionException {
        try {
            LocalTransaction trx = this.client.getLocalTransaction();
            if (trx != null) {
                logger.info("rolling back transaction...");
                trx.rollback();
                logger.info("done.");
            }
        }
        catch (ResourceException e) {
            throw new CTGTransactionException(e);
        }
    }

    public XAResource getXAResource() {
        return ResourceAdapterUtils.getXAResource(this.client);
    }

    public void close() {
        logger.info("XaTransaction close");
    }
}

