/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ibmctg.internal.connection;

import java.util.Arrays;
import javax.resource.ResourceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.mule.modules.ibmctg.internal.config.CTGConfig;
import org.mule.modules.ibmctg.internal.connection.CTGConnection;
import org.mule.modules.ibmctg.internal.connection.CTGConnectionProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.ExternalLibs;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExternalLibs(value={@ExternalLib(name="ccf2.jar", type=ExternalLibraryType.JAR, nameRegexpMatcher="ccf2(.*)\\.jar", requiredClassName="com.ibm.connector2.spi.DefaultConnectionManager"), @ExternalLib(name="cicsjee.jar", type=ExternalLibraryType.JAR, nameRegexpMatcher="cicsjee(.*)\\.jar"), @ExternalLib(name="ctgclient.jar", type=ExternalLibraryType.JAR, nameRegexpMatcher="ctgclient(.*)\\.jar"), @ExternalLib(name="ctgserver.jar", type=ExternalLibraryType.JAR, nameRegexpMatcher="ctgserver(.*)\\.jar"), @ExternalLib(name="geronimo-j2ee-connector_1.6_spec.jar", type=ExternalLibraryType.JAR, nameRegexpMatcher="geronimo-j2ee-connector_1.6_spec(.*)\\.jar")})
public class CTGConnectionProvider
implements ConnectionProvider<CTGConnection> {
    private static final Logger logger = LoggerFactory.getLogger(CTGConfig.class);
    @Parameter
    @Optional(defaultValue="localhost")
    @Example(value="")
    @DisplayName(value="Host")
    private String host;
    @Parameter
    @Optional(defaultValue="2006")
    @Example(value="")
    @DisplayName(value="Port")
    private String port;
    @Parameter
    @Example(value="")
    @DisplayName(value="Servers name")
    private String serverName;
    @Parameter
    @Example(value="")
    @DisplayName(value="Username")
    private String username;
    @Parameter
    @Example(value="")
    @DisplayName(value="Password")
    @Password
    private String password;
    @Parameter
    @DisplayName(value="Keystore location")
    @Placement(tab="Additional Settings")
    @Optional
    @Path
    private String keystoreLocation;
    @Parameter
    @DisplayName(value="Keystore Password")
    @Placement(tab="Additional Settings")
    @Optional
    @Password
    private String keystorePassword;
    @Parameter
    @Optional(defaultValue="0")
    @DisplayName(value="Connection Timeout")
    @Placement(tab="Additional Settings")
    private int connectionTimeout;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="CTG Trace")
    @Placement(tab="Additional Settings")
    private boolean ctgTrace;

    public CTGConnection connect() throws ConnectionException {
        try {
            CTGConnectionProfile profile = new CTGConnectionProfile();
            profile.setHost(this.host);
            profile.setPort(Integer.parseInt(this.port));
            profile.setServerName(this.serverName);
            profile.setUserName(this.username);
            profile.setPassword(this.password);
            profile.setCtgTrace(this.ctgTrace);
            profile.setConnectionTimeout(this.connectionTimeout);
            if (StringUtils.isNotBlank((CharSequence)this.getKeystoreLocation()) && StringUtils.isNotBlank((CharSequence)this.getKeystorePassword())) {
                profile.setSecure(true);
                profile.setKeyStore(this.getKeystoreLocation());
                profile.setKeyStorePassword(this.getKeystorePassword());
            } else if (StringUtils.isNotBlank((CharSequence)this.getKeystoreLocation()) || StringUtils.isNotBlank((CharSequence)this.getKeystorePassword())) {
                Validate.noNullElements(Arrays.asList(this.getKeystoreLocation(), this.getKeystorePassword()), (String)"To use a SSL connection, provide both the KeyStore Location and the KeyStore Password.", (Object[])new Object[0]);
            }
            return new CTGConnection(profile);
        }
        catch (ResourceException e) {
            throw new ConnectionException((Throwable)e);
        }
    }

    public void disconnect(CTGConnection connection) {
        connection.disconnect();
    }

    public ConnectionValidationResult validate(CTGConnection connection) {
        try {
            connection.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getKeystoreLocation() {
        return this.keystoreLocation;
    }

    public void setKeystoreLocation(String keystoreLocation) {
        this.keystoreLocation = keystoreLocation;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isCtgTrace() {
        return this.ctgTrace;
    }

    public void setCtgTrace(boolean ctgTrace) {
        this.ctgTrace = ctgTrace;
    }
}

