/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ibmctg.internal.service;

import com.google.common.base.Optional;
import com.ibm.connector2.cics.ECIChannelRecord;
import com.ibm.connector2.cics.ECIInteractionSpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.modules.ibmctg.api.ChannelAndContent;
import org.mule.modules.ibmctg.api.ChannelRequest;
import org.mule.modules.ibmctg.api.CommareaRequest;
import org.mule.modules.ibmctg.api.GenericRecord;
import org.mule.modules.ibmctg.internal.config.CTGConfig;
import org.mule.modules.ibmctg.internal.connection.CTGConnection;
import org.mule.modules.ibmctg.internal.exception.CTGRequestException;
import org.mule.modules.ibmctg.internal.service.CTGService;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTGServiceImpl
extends DefaultConnectorService<CTGConfig, CTGConnection>
implements CTGService {
    private static final Logger logger = LoggerFactory.getLogger(CTGServiceImpl.class);

    public CTGServiceImpl(CTGConfig config, CTGConnection connection) {
        super((ConnectorConfig)config, (ConnectorConnection)connection);
    }

    @Override
    public InputStream execute(InputStream content, ChannelRequest request) throws Exception {
        List<InputStream> responses = this.executeMultipleChannels(Collections.singletonList(new ChannelAndContent(request, content)));
        return responses.size() > 0 ? responses.get(0) : null;
    }

    @Override
    public List<InputStream> executeMultipleChannels(List<ChannelAndContent> requests) {
        Interaction interaction = null;
        boolean isFirstChannel = true;
        ECIChannelRecord channelRecord = null;
        ChannelRequest firstChannelRequest = null;
        ECIInteractionSpec eciInteractionSpec = null;
        ArrayList<InputStream> responses = new ArrayList<InputStream>();
        try {
            ChannelRequest request;
            interaction = ((CTGConnection)this.getConnection()).getClient().createInteraction();
            for (ChannelAndContent channelAndContent : (List)Optional.fromNullable(requests).or(Collections.emptyList())) {
                request = channelAndContent.getChannelRequest();
                if (isFirstChannel) {
                    isFirstChannel = false;
                    firstChannelRequest = request;
                    channelRecord = new ECIChannelRecord(firstChannelRequest.getChannel());
                    eciInteractionSpec = this.buildInteractionRequest(firstChannelRequest.getProgramName(), firstChannelRequest.getTpnName());
                }
                channelRecord.put((Object)request.getRequestContainer(), (Object)this.getPayloadAsBytes(channelAndContent.getContent()));
            }
            interaction.execute(eciInteractionSpec, channelRecord, channelRecord);
            for (ChannelAndContent channelAndContent : (List)Optional.fromNullable(requests).or(Collections.emptyList())) {
                request = channelAndContent.getChannelRequest();
                Object response = Optional.fromNullable((Object)(channelRecord.containsKey((Object)request.getResponseContainer()) ? channelRecord.get((Object)request.getResponseContainer()) : channelRecord.get((Object)request.getErrorContainer()))).orNull();
                if (response != null) {
                    responses.add(new ByteArrayInputStream(response instanceof String ? ((String)response).getBytes(Charset.forName(request.getEncoding())) : (byte[])response));
                    continue;
                }
                logger.warn("Unknown container name(s) {} {}", (Object)request.getResponseContainer(), (Object)request.getErrorContainer());
            }
        }
        catch (IOException | UnsupportedCharsetException | ResourceException e) {
            try {
                throw new CTGRequestException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(interaction);
                throw throwable;
            }
        }
        this.closeQuietly(interaction);
        return responses;
    }

    @Override
    public InputStream executeUsingCommarea(InputStream content, CommareaRequest commareaRequest) {
        Interaction interaction = null;
        try {
            logger.debug(commareaRequest.toString());
            interaction = ((CTGConnection)this.getConnection()).getClient().createInteraction();
            ECIInteractionSpec interactionRequest = this.buildInteractionRequest(commareaRequest.getProgramName(), commareaRequest.getTpnName());
            interactionRequest.setCommareaLength(commareaRequest.getCommareaLength());
            interactionRequest.setReplyLength(commareaRequest.getReplyLength());
            GenericRecord record = new GenericRecord(this.getPayloadAsBytes(content));
            ByteArrayInputStream byteArrayInputStream = interaction.execute((InteractionSpec)interactionRequest, (Record)record, (Record)record) ? new ByteArrayInputStream(record.getCommarea()) : null;
            this.closeQuietly(interaction);
            return byteArrayInputStream;
        }
        catch (IOException | ResourceException e) {
            try {
                throw new CTGRequestException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(interaction);
                throw throwable;
            }
        }
    }

    private void closeQuietly(Interaction interaction) {
        if (interaction != null) {
            try {
                interaction.close();
            }
            catch (ResourceException e) {
                logger.warn("Unable to close communication with CICS", (Throwable)e);
            }
        }
    }

    private ECIInteractionSpec buildInteractionRequest(String programName, String tpnName) throws ResourceException {
        ECIInteractionSpec interactionSpec = new ECIInteractionSpec();
        interactionSpec.setFunctionName(programName);
        interactionSpec.setInteractionVerb(1);
        if (StringUtils.isNotEmpty((CharSequence)tpnName)) {
            interactionSpec.setTPNName(tpnName);
        }
        return interactionSpec;
    }

    private byte[] getPayloadAsBytes(InputStream payload) throws IOException {
        if (payload == null || payload.available() < 1) {
            logger.warn("Payload contents are null or empty");
            return new byte[0];
        }
        return IOUtils.toByteArray((InputStream)payload);
    }
}

