/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ibmctg.internal.service.xa;

import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceObjectFactory;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.xa.XAResource;
import org.mule.modules.ibmctg.internal.exception.CTGTransactionException;
import org.mule.modules.ibmctg.internal.service.xa.CTGXAResourceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTGXAResourceProducer
extends ResourceBean
implements XAResourceProducer {
    private static final long serialVersionUID = -1152920783331492048L;
    private static final Logger logger = LoggerFactory.getLogger(CTGXAResourceProducer.class);
    private static final ConcurrentMap<String, CTGXAResourceProducer> producers = new ConcurrentHashMap<String, CTGXAResourceProducer>();
    private final transient ConcurrentMap<Integer, CTGXAResourceHolder> xaResourceHolders = new ConcurrentHashMap<Integer, CTGXAResourceHolder>();
    private final AtomicInteger xaResourceHolderCounter = new AtomicInteger();
    private volatile transient RecoveryXAResourceHolder recoveryXAResourceHolder;

    private CTGXAResourceProducer() {
        this.setApplyTransactionTimeout(true);
    }

    public static void registerXAResource(String uniqueName, XAResource xaResource) {
        CTGXAResourceProducer xaResourceProducer = (CTGXAResourceProducer)((Object)producers.get(uniqueName));
        if (xaResourceProducer == null) {
            xaResourceProducer = new CTGXAResourceProducer();
            xaResourceProducer.setUniqueName(uniqueName);
            xaResourceProducer.addXAResource(xaResource);
            CTGXAResourceProducer previous = producers.putIfAbsent(uniqueName, xaResourceProducer);
            if (previous == null) {
                xaResourceProducer.init();
            } else {
                previous.addXAResource(xaResource);
            }
        } else {
            xaResourceProducer.addXAResource(xaResource);
        }
    }

    public static void unregisterXAResource(String uniqueName, XAResource xaResource) {
        CTGXAResourceProducer xaResourceProducer = (CTGXAResourceProducer)((Object)producers.get(uniqueName));
        if (xaResourceProducer != null) {
            boolean found = xaResourceProducer.removeXAResource(xaResource);
            if (!found) {
                logger.error("No XAResource {} found in XAResourceProducer with name {}", (Object)xaResource, (Object)uniqueName);
            }
            if (xaResourceProducer.xaResourceHolders.isEmpty()) {
                xaResourceProducer.close();
                producers.remove(uniqueName);
            }
        } else {
            logger.error("No XAResourceProducer registered with name {}", (Object)uniqueName);
        }
    }

    private void addXAResource(XAResource xaResource) {
        this.xaResourceHolders.put(this.xaResourceHolderCounter.incrementAndGet(), new CTGXAResourceHolder(xaResource, this));
    }

    private boolean removeXAResource(XAResource xaResource) {
        for (Map.Entry entry : this.xaResourceHolders.entrySet()) {
            Integer key = (Integer)entry.getKey();
            CTGXAResourceHolder xaResourceHolder = (CTGXAResourceHolder)((Object)entry.getValue());
            if (xaResourceHolder.getXAResource() != xaResource) continue;
            this.xaResourceHolders.remove(key);
            return true;
        }
        return false;
    }

    public XAResourceHolderState startRecovery() {
        try {
            if (this.recoveryXAResourceHolder != null) {
                throw new RecoveryException(String.format("Recovery already in progress on %s", new Object[]{this}));
            }
            if (this.xaResourceHolders.isEmpty()) {
                throw new RecoveryException(String.format("No XAResource registered, recovery cannot be done on %s", new Object[]{this}));
            }
            this.recoveryXAResourceHolder = new RecoveryXAResourceHolder((XAResourceHolder)this.xaResourceHolders.values().iterator().next());
            return new XAResourceHolderState((XAResourceHolder)this.recoveryXAResourceHolder, (ResourceBean)this);
        }
        catch (RecoveryException e) {
            throw new CTGTransactionException(e);
        }
    }

    public void endRecovery() {
        this.recoveryXAResourceHolder = null;
    }

    public void setFailed(boolean failed) {
    }

    public CTGXAResourceHolder findXAResourceHolder(XAResource xaResource) {
        return this.xaResourceHolders.values().stream().filter(xaResourceHolder -> xaResource == xaResourceHolder.getXAResource()).findFirst().get();
    }

    public void init() {
        try {
            ResourceRegistrar.register((XAResourceProducer)this);
        }
        catch (RecoveryException e) {
            throw new CTGTransactionException(e);
        }
    }

    public void close() {
        this.xaResourceHolders.clear();
        this.xaResourceHolderCounter.set(0);
        ResourceRegistrar.unregister((XAResourceProducer)this);
    }

    public CTGXAResourceHolder createPooledConnection(Object xaFactory, ResourceBean bean) {
        throw new UnsupportedOperationException("IBM CTG is not connection-oriented");
    }

    public Reference getReference() throws NamingException {
        return new Reference(CTGXAResourceProducer.class.getName(), new StringRefAddr("uniqueName", this.getUniqueName()), ResourceObjectFactory.class.getName(), null);
    }

    public String toString() {
        return "A CTGXAResourceProducer with uniqueName " + this.getUniqueName();
    }
}

