/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ibmctg.internal.service.xa;

import com.ibm.connector2.cics.ECIConnection;
import com.ibm.connector2.cics.ECIManagedConnection;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.UUID;
import javax.resource.cci.Connection;
import javax.transaction.xa.XAResource;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.modules.ibmctg.internal.exception.CTGTransactionException;
import org.mule.modules.ibmctg.internal.service.xa.CTGXAResourceProducer;
import org.mule.modules.ibmctg.internal.service.xa.CTGXAResourceWrapper;
import org.mule.runtime.core.api.util.NetworkUtils;

public class ResourceAdapterUtils {
    private static final String BITRONIX_SERVER_ID = "mule.bitronix.serverId";
    private static final String CLUSTER_NODE_ID_PROPERTY = "mule.clusterNodeId";

    private ResourceAdapterUtils() {
    }

    public static XAResource getXAResource(Connection connection) {
        CTGXAResourceWrapper xaResource;
        ECIConnection eciConnection = (ECIConnection)connection;
        try {
            CTGXAResourceWrapper xaResourceWrapper;
            Method method = eciConnection.getClass().getDeclaredMethod("getManagedConnection", new Class[0]);
            method.setAccessible(true);
            xaResource = xaResourceWrapper = new CTGXAResourceWrapper(connection, ((ECIManagedConnection)method.invoke((Object)eciConnection, new Object[0])).getXAResource());
            CTGXAResourceProducer.registerXAResource(Optional.ofNullable(System.getProperty(BITRONIX_SERVER_ID)).orElse(ResourceAdapterUtils.createUniqueResourceName()), (XAResource)((Object)xaResourceWrapper));
        }
        catch (Exception e) {
            throw new CTGTransactionException((Throwable)e);
        }
        return xaResource;
    }

    private static String createUniqueResourceName() {
        try {
            InetAddress address = NetworkUtils.getLocalHost();
            int uniqueIdForServer = Math.abs(new HashCodeBuilder(17, 37).append((Object)address.getHostName()).append((Object)address.getHostName()).append((Object)System.getProperty(CLUSTER_NODE_ID_PROPERTY, "0")).toHashCode());
            return String.format("%s-%s-ctg", uniqueIdForServer, UUID.randomUUID());
        }
        catch (UnknownHostException e) {
            throw new CTGTransactionException((Throwable)e);
        }
    }
}

