/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ibmctg.internal.service.xa;

import bitronix.tm.utils.Uid;
import javax.resource.cci.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.mule.modules.ibmctg.internal.util.XATraceType;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.api.util.queue.Queue;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.util.queue.TransactionAwareQueueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTGXAResourceWrapper
implements QueueSession {
    private static final Logger logger = LoggerFactory.getLogger(CTGXAResourceWrapper.class);
    private Connection connection;
    private XAResource delegate;

    public CTGXAResourceWrapper(Connection connection, XAResource delegate) {
        this.connection = connection;
        this.delegate = delegate;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void commit(Xid arg0, boolean arg1) throws XAException {
        this.log("Commit Xid: ", arg0, 0);
        this.delegate.commit(arg0, arg1);
    }

    public void end(Xid arg0, int arg1) throws XAException {
        this.log("End Xid: ", arg0, arg1);
        this.delegate.end(arg0, arg1);
    }

    public void forget(Xid arg0) throws XAException {
        this.log("Forget Xid: ", arg0, 0);
        this.delegate.forget(arg0);
    }

    public int getTransactionTimeout() throws XAException {
        return this.delegate.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource arg0) throws XAException {
        logger.debug("isSameRM: ", (Object)arg0);
        return this.delegate.isSameRM(arg0);
    }

    public int prepare(Xid arg0) throws XAException {
        this.log("Prepared Xid: ", arg0, 0);
        return this.delegate.prepare(arg0);
    }

    public Xid[] recover(int arg0) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid arg0) throws XAException {
        this.delegate.rollback(arg0);
        this.log("Rollback Xid: ", arg0, 0);
    }

    public boolean setTransactionTimeout(int arg0) throws XAException {
        return this.delegate.setTransactionTimeout(arg0);
    }

    public void start(Xid arg0, int arg1) throws XAException {
        this.delegate.start(arg0, arg1);
        this.log("Started Xid: ", arg0, arg1);
    }

    private void log(String msg, Xid xid, int arg) {
        logger.info(String.format("%s %s. Status flag: %s", new Object[]{msg, new Uid(xid.getGlobalTransactionId()).toString(), XATraceType.valueOf(arg)}));
    }

    public Queue getQueue(String s) {
        return new TransactionAwareQueueStore(null, null, null);
    }

    public void begin() throws ResourceManagerException {
    }

    public void commit() throws ResourceManagerException {
    }

    public void rollback() throws ResourceManagerException {
    }
}

