/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.connection;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQXAConnectionFactory;
import com.mulesoft.connectors.ibmmq.internal.connection.enricher.ConnectionFactoryEnricher;
import com.mulesoft.connectors.ibmmq.internal.exception.ConnectionCreationException;
import java.util.Map;
import java.util.function.Supplier;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class IBMMQConnectionFactorySupplier
implements Supplier<ConnectionFactory> {
    private final String clientId;
    private Map<String, String> additionalProperties;
    private boolean enableXa;
    private ConnectionFactoryEnricher[] configurators;

    IBMMQConnectionFactorySupplier(String clientId, Map<String, String> additionalProperties, boolean enableXa, ConnectionFactoryEnricher ... configurators) {
        this.enableXa = enableXa;
        this.configurators = configurators;
        this.clientId = clientId;
        this.additionalProperties = additionalProperties;
    }

    @Override
    public ConnectionFactory get() {
        MQXAConnectionFactory mqConnectionFactory = this.enableXa ? new MQXAConnectionFactory() : new MQConnectionFactory();
        try {
            for (ConnectionFactoryEnricher configurator : this.configurators) {
                configurator.configure((MQConnectionFactory)mqConnectionFactory);
            }
        }
        catch (JMSException e) {
            throw new ConnectionCreationException("Unknown error when creating the connection factory", e);
        }
        mqConnectionFactory.putAll(this.additionalProperties);
        return mqConnectionFactory;
    }
}

