/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.listener;

import com.ibm.mq.jms.MQConnection;
import com.ibm.msg.client.jms.internal.JmsConnectionImpl;
import java.lang.reflect.Field;
import javax.jms.Connection;
import org.mule.jms.commons.internal.source.JmsConnectionCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQJmsConnectionCleaner
implements JmsConnectionCleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQJmsConnectionCleaner.class);

    public void clean(Connection connection) {
        MQConnection mqConnection = (MQConnection)connection;
        try {
            Field jmsConnectionField = MQConnection.class.getDeclaredField("commonConn");
            jmsConnectionField.setAccessible(true);
            JmsConnectionImpl jmsConnection = (JmsConnectionImpl)jmsConnectionField.get(mqConnection);
            Field exceptionListenerProxyField = JmsConnectionImpl.class.getDeclaredField("exceptionListenerProxy");
            exceptionListenerProxyField.setAccessible(true);
            Object providerExceptionListener = exceptionListenerProxyField.get(jmsConnection);
            Field connectionExceptionReceivedField = providerExceptionListener.getClass().getDeclaredField("connectionBrokenExReceived");
            connectionExceptionReceivedField.setAccessible(true);
            connectionExceptionReceivedField.set(providerExceptionListener, false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error(String.format("An error occurred while cleaning the JMS Connection %s:", connection), (Throwable)e);
        }
    }
}

