/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.listener;

import com.ibm.msg.client.jms.internal.JmsConnectionImpl;
import java.lang.reflect.Field;
import javax.jms.Connection;
import org.mule.jms.commons.internal.source.DefaultJmsResourceReleaser;
import org.mule.jms.commons.internal.source.push.MessageListenerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQJmsResourceReleaser
extends DefaultJmsResourceReleaser {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void releaseConsumerMessageListener(MessageListenerContext info) {
        info.getListener().setEnabled(false);
    }

    protected void doCleanConnection(Connection connection) {
        try {
            JmsConnectionImpl jmsConnection = (JmsConnectionImpl)this.setAccessibleAndGetFieldValue(connection, "commonConn");
            Object providerExceptionListener = this.setAccessibleAndGetFieldValue(jmsConnection, "exceptionListenerProxy");
            this.setAccessibleAndSetFieldValue(providerExceptionListener, "connectionBrokenExReceived", false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.LOGGER.debug(String.format("An error occurred accessing MQ Connection [%s] for cleanup:", connection.getClass().getName()), (Throwable)e);
        }
    }

    private Object setAccessibleAndGetFieldValue(Object fieldOwner, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = fieldOwner.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(fieldOwner);
    }

    private void setAccessibleAndSetFieldValue(Object fieldOwner, String fieldName, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        Field field = fieldOwner.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(fieldOwner, newValue);
    }
}

