/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.listener;

import com.mulesoft.connectors.ibmmq.api.ack.AckMode;
import com.mulesoft.connectors.ibmmq.api.consumer.MQConsumerType;
import com.mulesoft.connectors.ibmmq.api.publisher.MQResponseMessageBuilder;
import com.mulesoft.connectors.ibmmq.internal.IBMMQConfiguration;
import com.mulesoft.connectors.ibmmq.internal.MQConnectionExceptionResolver;
import com.mulesoft.connectors.ibmmq.internal.MediaTypeOverridingParameters;
import com.mulesoft.connectors.ibmmq.internal.connection.IBMMQSessionManager;
import com.mulesoft.connectors.ibmmq.internal.listener.MQJmsResourceReleaser;
import com.mulesoft.connectors.ibmmq.internal.lock.ManagedJmsListenerLockFactory;
import com.mulesoft.connectors.ibmmq.internal.metadata.AnyOutputResolver;
import com.mulesoft.connectors.ibmmq.internal.metadata.MQAttributesOutputResolver;
import javax.inject.Inject;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.lock.JmsListenerLockFactory;
import org.mule.jms.commons.internal.config.JmsAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.source.JmsConnectionExceptionResolver;
import org.mule.jms.commons.internal.source.JmsListener;
import org.mule.jms.commons.internal.source.JmsResourceReleaser;
import org.mule.jms.commons.internal.source.JmsResponseMessageBuilder;
import org.mule.jms.commons.internal.source.SourceConfiguration;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.source.ClusterSupport;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.runtime.connectivity.Reconnectable;
import org.mule.runtime.extension.api.runtime.connectivity.ReconnectionCallback;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;

@Alias(value="listener")
@DisplayName(value="On New Message")
@EmitsResponse
@ClusterSupport(value=SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY)
@MetadataScope(outputResolver=AnyOutputResolver.class, attributesResolver=MQAttributesOutputResolver.class)
public class MQMessageListener
extends Source<Object, Object>
implements Reconnectable {
    private JmsListener jmsListener;
    private SourceTransactionalAction transactionalAction;
    private TransactionType transactionType;
    private ComponentLocation componentLocation;
    @RefName
    String configName;
    @Inject
    private IBMMQSessionManager sessionManager;
    @Config
    private IBMMQConfiguration config;
    @Connection
    private ConnectionProvider<JmsTransactionalConnection> connectionProvider;
    @Parameter
    @Summary(value="The name of the Destination from where the Message should be consumed")
    private String destination;
    @Parameter
    @ConfigOverride
    @Summary(value="The Type of the Consumer that should be used for the provided destination")
    private MQConsumerType consumerType;
    @Parameter
    @Optional
    @Summary(value="The Session ACK mode to use when consuming a message")
    private AckMode ackMode;
    @Parameter
    @ConfigOverride
    @Summary(value="JMS selector to be used for filtering incoming messages")
    private String selector;
    @ParameterGroup(name="Media Type Overriding")
    private MediaTypeOverridingParameters mediaTypeOverriding;
    @Parameter
    @Optional(defaultValue="4")
    @Summary(value="The number of concurrent consumers that will be used to receive JMS Messages")
    private int numberOfConsumers;
    @Inject
    private SchedulerService schedulerService;
    private ManagedJmsListenerLockFactory lockFactory;

    public void onStart(SourceCallback<Object, Object> sourceCallback) throws MuleException {
        this.lockFactory = new ManagedJmsListenerLockFactory(JmsListenerLockFactory.newDefault());
        this.jmsListener = new JmsListener((JmsSessionManager)this.sessionManager, (JmsConfig)this.config, this.connectionProvider, this.destination, (ConsumerType)this.consumerType, (JmsAckMode)this.ackMode, this.selector, this.mediaTypeOverriding.getContentType(), this.mediaTypeOverriding.getEncoding(), this.numberOfConsumers, new SourceConfiguration(this.transactionalAction, this.transactionType, this.componentLocation, this.configName), this.schedulerService, (JmsConnectionExceptionResolver)new MQConnectionExceptionResolver(), (JmsResourceReleaser)new MQJmsResourceReleaser(), (JmsListenerLockFactory)this.lockFactory);
        this.jmsListener.onStart(sourceCallback);
    }

    public void onStop() {
        if (this.jmsListener != null) {
            this.jmsListener.onStop();
        }
    }

    @OnError
    public void onError(Error error, SourceCallbackContext callbackContext) {
        this.jmsListener.onError(error, callbackContext);
    }

    @OnSuccess
    public void onSuccess(@ParameterGroup(name="Reply-To Response", showInDsl=true) MQResponseMessageBuilder messageBuilder, CorrelationInfo correlationInfo, SourceCallbackContext callbackContext) {
        this.jmsListener.onSuccess((JmsResponseMessageBuilder)messageBuilder, correlationInfo, callbackContext);
    }

    public void reconnect(ConnectionException connectionException, ReconnectionCallback reconnectionCallback) {
        this.lockFactory.setEnabled(false);
        this.jmsListener.disableConsumers();
        this.lockFactory.releaseOutstandingLocks();
        try {
            this.jmsListener.restart();
            reconnectionCallback.success();
        }
        catch (Throwable t) {
            this.handleReconnectionError(reconnectionCallback, t);
        }
    }

    private void handleReconnectionError(ReconnectionCallback reconnectionCallback, Throwable t) {
        reconnectionCallback.failed(new ConnectionException("Failed to reconnect ibm listener at flow " + this.componentLocation.getRootContainerName(), t));
    }
}

