/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.connection.support;

import com.mulesoft.connectors.ibmmq.api.MQTargetClient;
import com.mulesoft.connectors.ibmmq.internal.connection.MQDestinationConfiguration;
import com.mulesoft.connectors.ibmmq.internal.connection.support.MQSupportUtils;
import java.util.Optional;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.mule.jms.commons.api.exception.DestinationNotFoundException;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.support.Jms20Support;

public class MQJms20Support
extends Jms20Support {
    private MQTargetClient targetClient;
    private MQDestinationConfiguration destinationConfiguration;

    public MQJms20Support(MQTargetClient targetClient, MQDestinationConfiguration destinationConfiguration) {
        this.targetClient = targetClient;
        this.destinationConfiguration = destinationConfiguration;
    }

    public Destination createDestination(Session session, String name, boolean topic, JmsConfig config) throws JMSException, DestinationNotFoundException {
        Destination destination = super.createDestination(session, name, topic, config);
        return MQSupportUtils.enrichDestination(destination, this.targetClient, this.destinationConfiguration);
    }

    protected Optional<Destination> createDestinationFromJndi(String name) throws JMSException {
        Optional<Destination> destinationFromJndi = super.createDestinationFromJndi(name);
        if (destinationFromJndi.isPresent()) {
            destinationFromJndi = Optional.ofNullable(MQSupportUtils.enrichDestination((Destination)destinationFromJndi.get(), this.targetClient, this.destinationConfiguration));
        }
        return destinationFromJndi;
    }
}

