/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.operation;

import com.mulesoft.connectors.ibmmq.api.MQDestinationType;
import com.mulesoft.connectors.ibmmq.api.RequestReplyPattern;
import com.mulesoft.connectors.ibmmq.api.ack.ConsumerAckMode;
import com.mulesoft.connectors.ibmmq.api.consumer.MQConsumeParameters;
import com.mulesoft.connectors.ibmmq.api.consumer.MQConsumerType;
import com.mulesoft.connectors.ibmmq.internal.IBMMQConfiguration;
import com.mulesoft.connectors.ibmmq.internal.MQMessageBuilder;
import com.mulesoft.connectors.ibmmq.internal.MediaTypeOverridingParameters;
import com.mulesoft.connectors.ibmmq.internal.connection.IBMMQSessionManager;
import com.mulesoft.connectors.ibmmq.internal.metadata.AnyOutputResolver;
import com.mulesoft.connectors.ibmmq.internal.metadata.MQAttributesOutputResolver;
import com.mulesoft.connectors.ibmmq.internal.operation.IBMRequestReplySelectorWrapper;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.jms.commons.api.RequestReplyPatternWrapper;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.destination.DestinationTypeDescriptor;
import org.mule.jms.commons.api.exception.JmsAckErrorTypeProvider;
import org.mule.jms.commons.api.exception.JmsConsumeErrorTypeProvider;
import org.mule.jms.commons.api.exception.JmsPublishConsumeErrorTypeProvider;
import org.mule.jms.commons.api.exception.JmsPublisherErrorTypeProvider;
import org.mule.jms.commons.api.exception.JmsSessionRecoverErrorTypeProvider;
import org.mule.jms.commons.api.message.JmsMessageBuilder;
import org.mule.jms.commons.internal.config.JmsAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.consume.JmsConsumeParameters;
import org.mule.jms.commons.internal.operation.JmsAcknowledge;
import org.mule.jms.commons.internal.operation.JmsConsume;
import org.mule.jms.commons.internal.operation.JmsPublish;
import org.mule.jms.commons.internal.operation.JmsPublishConsume;
import org.mule.jms.commons.internal.publish.JmsPublishParameters;
import org.mule.jms.commons.internal.publish.PublisherParameters;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQOperations
implements Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQOperations.class);
    @Inject
    private IBMMQSessionManager sessionManager;
    @Inject
    private SchedulerService schedulerService;
    private JmsConsume consumeOperation;
    private JmsPublish publishOperation;
    private JmsPublishConsume publishConsumeOperation;
    private JmsAcknowledge acknowledgeOperations;

    public void initialise() {
        this.consumeOperation = new JmsConsume((JmsSessionManager)this.sessionManager, this.schedulerService);
        this.publishOperation = new JmsPublish((JmsSessionManager)this.sessionManager, this.schedulerService);
        this.publishConsumeOperation = new JmsPublishConsume((JmsSessionManager)this.sessionManager, this.schedulerService, (RequestReplyPatternWrapper)new IBMRequestReplySelectorWrapper());
        this.acknowledgeOperations = new JmsAcknowledge((JmsSessionManager)this.sessionManager);
    }

    public void dispose() {
        this.disposeQuietly(new Disposable[]{this.consumeOperation, this.publishConsumeOperation, this.publishOperation});
    }

    @OutputResolver(output=AnyOutputResolver.class, attributes=MQAttributesOutputResolver.class)
    @Throws(value={JmsConsumeErrorTypeProvider.class})
    public void consume(@Config IBMMQConfiguration config, @Connection JmsTransactionalConnection connection, @Summary(value="The name of the Destination from where the Message should be consumed") String destination, @ConfigOverride @Expression(value=ExpressionSupport.NOT_SUPPORTED) @Summary(value="The Type of the Consumer that should be used for the provided destination") MQConsumerType consumerType, @Optional @Summary(value="The Session ACK mode to use when consuming a message") ConsumerAckMode ackMode, @ConfigOverride @Summary(value="The JMS selector to be used for filtering incoming messages") String selector, @Placement(tab="Advanced") @ParameterGroup(name="MediaType Override") MediaTypeOverridingParameters mediaTypeOverriding, @Optional(defaultValue="10000") @Summary(value="Maximum time to wait for a message to arrive before timeout") Long maximumWait, @Optional(defaultValue="MILLISECONDS") @Example(value="MILLISECONDS") @Summary(value="Time unit to be used in the maximumWaitTime configuration") TimeUnit maximumWaitUnit, OperationTransactionalAction transactionalAction, CompletionCallback<Object, Object> completionCallback) {
        this.consumeOperation.consume((JmsConfig)config, connection, destination, (ConsumerType)consumerType, (JmsAckMode)ackMode, selector, mediaTypeOverriding.getContentType(), mediaTypeOverriding.getEncoding(), maximumWait, maximumWaitUnit, transactionalAction, completionCallback);
    }

    @Throws(value={JmsPublisherErrorTypeProvider.class})
    public void publish(@Config IBMMQConfiguration config, @Connection JmsTransactionalConnection connection, @Summary(value="The name of the Destination where the Message should be sent") String destination, @Optional(defaultValue="QUEUE") @Summary(value="The type of the Destination") MQDestinationType destinationType, @Summary(value="A builder for the message that will be published") @ParameterGroup(name="Message", showInDsl=true) MQMessageBuilder messageBuilder, @ParameterGroup(name="Publish Configuration") JmsPublishParameters overrides, OperationTransactionalAction transactionalAction, @ConfigOverride OutboundCorrelationStrategy sendCorrelationId, CorrelationInfo correlationInfo, CompletionCallback<Void, Void> completionCallback) {
        this.publishOperation.publish((JmsConfig)config, connection, destination, (DestinationTypeDescriptor)destinationType, (JmsMessageBuilder)messageBuilder, (PublisherParameters)overrides, transactionalAction, sendCorrelationId, correlationInfo, completionCallback);
    }

    @OutputResolver(output=AnyOutputResolver.class, attributes=MQAttributesOutputResolver.class)
    @Throws(value={JmsPublishConsumeErrorTypeProvider.class})
    public void publishConsume(@Config IBMMQConfiguration config, @Connection JmsConnection connection, @Placement(order=0) @Summary(value="The name of the Queue destination where the Message should be sent") String destination, @Placement(order=1) @Summary(value="A builder for the message that will be published") @ParameterGroup(name="Message", showInDsl=true) MQMessageBuilder messageBuilder, @Placement(order=2) @ParameterGroup(name="Publish Configuration", showInDsl=true) JmsPublishParameters publishParameters, @Placement(order=3) @ParameterGroup(name="Consume Configuration", showInDsl=true) MQConsumeParameters consumeParameters, @Optional(defaultValue="CORRELATION_ID") @DisplayName(value="Request-Reply Pattern") RequestReplyPattern requestReplyPattern, @ConfigOverride @DisplayName(value="Send Correlation ID") OutboundCorrelationStrategy sendCorrelationId, CorrelationInfo correlationInfo, CompletionCallback<Object, Object> completionCallback) {
        this.publishConsumeOperation.publishConsume((JmsConfig)config, connection, destination, (JmsMessageBuilder)messageBuilder, publishParameters, (JmsConsumeParameters)consumeParameters, sendCorrelationId, correlationInfo, requestReplyPattern.get(), completionCallback);
    }

    @Throws(value={JmsAckErrorTypeProvider.class})
    public void ack(@Summary(value="The AckId of the Message to ACK") String ackId, CompletionCallback<Void, Void> completionCallback) {
        this.acknowledgeOperations.ack(ackId, completionCallback);
    }

    @Throws(value={JmsSessionRecoverErrorTypeProvider.class})
    public void recoverSession(String ackId, CompletionCallback<Void, Void> completionCallback) {
        this.acknowledgeOperations.recoverSession(ackId, completionCallback);
    }

    private void disposeQuietly(Disposable ... disposables) {
        for (Disposable disposable : disposables) {
            try {
                disposable.dispose();
            }
            catch (Throwable e) {
                LOGGER.warn("An error occurred trying to dispose IBM Operations");
            }
        }
    }
}

