/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.connection.enricher;

import com.ibm.mq.jms.MQConnectionFactory;
import com.mulesoft.connectors.ibmmq.internal.connection.enricher.ConnectionFactoryEnricher;
import javax.jms.JMSException;
import org.mule.runtime.api.component.ConfigurationProperties;

public class ApplicationNameEnricher
implements ConnectionFactoryEnricher {
    private final String userAppName;
    private final ConfigurationProperties configurationProperties;

    public ApplicationNameEnricher(String userAppName, ConfigurationProperties configurationProperties) {
        this.userAppName = userAppName;
        this.configurationProperties = configurationProperties;
    }

    @Override
    public void configure(MQConnectionFactory connectionFactory) throws JMSException {
        String appName = this.userAppName;
        if (this.userAppName == null) {
            appName = this.configurationProperties.resolveStringProperty("app.name").orElse(null);
        }
        if (appName != null) {
            connectionFactory.setAppName(this.normalizeAppName(appName));
        }
    }

    private String normalizeAppName(String appName) {
        if (appName.length() >= 28) {
            return appName.substring(0, 27);
        }
        return appName;
    }
}

