/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.api.ssl;

import com.mulesoft.connectors.ibmmq.api.ssl.CipherSuiteMapping;
import com.mulesoft.connectors.ibmmq.api.ssl.CipherSuiteMappingValueProvider;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;

public class SSLConfiguration {
    @Parameter
    @Placement(tab="TLS/SSL")
    @Optional(defaultValue="ORACLE_CIPHER_SUITES")
    @Summary(value="Defines which Cipher Suite Mapping to use. Oracle JDK or IBM JDK. Configure depending on the Host JDK. More information: https://www.ibm.com/support/knowledgecenter/en/SSFKSJ_8.0.0/com.ibm.mq.dev.doc/q113220_.htm")
    @DisplayName(value="IBM MQ CipherSpec Mapping")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ExcludeFromConnectivitySchema
    private CipherSuiteMapping cipherSuiteMapping;
    @Parameter
    @Placement(tab="TLS/SSL")
    @Optional
    @Summary(value="Cipher Suite to use to connect to the IBM MQ Server")
    @DisplayName(value="IBM Cipher Suite")
    @Example(value="TLS_RSA_WITH_AES_128_CBC_SHA256")
    @OfValues(value=CipherSuiteMappingValueProvider.class)
    @ExcludeFromConnectivitySchema
    private String cipherSuite;
    @Parameter
    @Placement(tab="TLS/SSL")
    @DisplayName(value="TLS Context")
    @Optional
    private TlsContextFactory tlsContextFactory;
    @Parameter
    @Optional
    @Placement(tab="TLS/SSL")
    @Summary(value="This property represents the total number of bytes sent and received by a connection before the secret key that is used for encryption is renegotiated. Integer value between 0 (disabled) and 999999999.")
    @DisplayName(value="Reset Count")
    @ExcludeFromConnectivitySchema
    private Integer resetCount;
    @Parameter
    @Optional
    @Placement(tab="TLS/SSL")
    @Summary(value="Specifies a distinguished name pattern, to ensure that your JMS application connects to the correct queue manager.")
    @DisplayName(value="Peer Name")
    @ExcludeFromConnectivitySchema
    private String peerName;
    @Parameter
    @Placement(tab="TLS/SSL")
    @Optional(defaultValue="false")
    @Summary(value="Enable it if is required a connection to use a CipherSuite that is supported by the IBM Java JSSE FIPS provider (IBMJSSEFIPS)")
    @DisplayName(value="FIPS Required")
    @ExcludeFromConnectivitySchema
    private boolean fipsRequired;
    @Parameter
    @Optional
    @Placement(tab="TLS/SSL")
    @Summary(value="Specifies a list of LDAP servers to use for certificate revocation list (CRL) checking.")
    @DisplayName(value="Cert Stores")
    @ExcludeFromConnectivitySchema
    private String certStores;

    public String getCipherSuite() {
        return this.cipherSuite;
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }

    public Integer getResetCount() {
        return this.resetCount;
    }

    public String getPeerName() {
        return this.peerName;
    }

    public boolean isFipsRequired() {
        return this.fipsRequired;
    }

    public String getCertStores() {
        return this.certStores;
    }

    public CipherSuiteMapping cipherSpecMapping() {
        return this.cipherSuiteMapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSLConfiguration that = (SSLConfiguration)o;
        return this.fipsRequired == that.fipsRequired && Objects.equals(this.cipherSuite, that.cipherSuite) && this.cipherSuiteMapping == that.cipherSuiteMapping && Objects.equals(this.tlsContextFactory, that.tlsContextFactory) && Objects.equals(this.resetCount, that.resetCount) && Objects.equals(this.peerName, that.peerName) && Objects.equals(this.certStores, that.certStores);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cipherSuite, this.cipherSuiteMapping, this.tlsContextFactory, this.resetCount, this.peerName, this.fipsRequired, this.certStores});
    }
}

